/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.ui;

import com.badlogic.gdx.InputProcessor;
import java.util.Optional;
import org.destinationsol.game.screens.ConsoleScreen;
import org.destinationsol.ui.SolInputManager;

public class SolInputProcessor
implements InputProcessor {
    private final SolInputManager inputManager;

    SolInputProcessor(SolInputManager inputMan) {
        this.inputManager = inputMan;
    }

    public boolean keyDown(int keyCode) {
        this.inputManager.maybeFlashPressed(keyCode);
        return false;
    }

    public boolean keyUp(int keycode) {
        return false;
    }

    public boolean keyTyped(char character) {
        Optional<ConsoleScreen> optionalScreen = ConsoleScreen.getInstance();
        if (optionalScreen.isPresent()) {
            optionalScreen.get().onCharEntered(character);
        }
        return false;
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        this.inputManager.maybeFlashPressed(screenX, screenY);
        return false;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        this.inputManager.maybeTouchDragged(screenX, screenY);
        return false;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    public boolean scrolled(int amount) {
        this.inputManager.scrolled(amount > 0);
        return false;
    }
}

