/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import org.destinationsol.SolApplication;
import org.destinationsol.common.SolColor;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.Position;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.UiDrawer;

public class SolUiControl {
    private final int[] keys;
    private Rectangle screenArea;
    private final boolean isWithSound;
    private String displayName;
    private boolean isEnabled = true;
    private boolean isKeyPressed;
    private boolean wasKeyPressed;
    private boolean isKeyFlashed;
    private boolean isAreaPressed;
    private boolean isAreaFlashed;
    private boolean isAreaJustUnpressed;
    private boolean doesMouseHover;
    private int warnCount;
    private int width;
    private int height;
    private Position referencePosition;
    private int offsetX;
    private int offsetY;

    public SolUiControl(Rectangle screenArea, boolean isWithSound, int ... keys) {
        this.isWithSound = isWithSound;
        this.keys = keys == null ? new int[]{} : keys;
        this.screenArea = screenArea;
    }

    public SolUiControl(int width, int height, Position referencePosition, int offsetX, int offsetY, boolean isWithSound, int ... keys) {
        this.isWithSound = isWithSound;
        this.keys = keys == null ? new int[]{} : keys;
        this.width = width;
        this.height = height;
        this.referencePosition = referencePosition;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.computePosition();
    }

    public boolean maybeFlashPressed(int keyCode) {
        if (!this.isEnabled) {
            return false;
        }
        for (int key : this.keys) {
            if (key != keyCode) continue;
            this.isKeyFlashed = true;
            return true;
        }
        return false;
    }

    public boolean maybeFlashPressed(SolInputManager.InputPointer inputPointer) {
        boolean pressed;
        if (!this.isEnabled) {
            return false;
        }
        boolean bl = pressed = this.screenArea != null && this.screenArea.contains(inputPointer.x, inputPointer.y);
        if (pressed) {
            this.isAreaFlashed = true;
        }
        return pressed;
    }

    public void update(SolInputManager.InputPointer[] inputPointers, boolean cursorShown, boolean canBePressed, SolInputManager inputMan, SolApplication cmp) {
        if (!this.isEnabled) {
            canBePressed = false;
        }
        this.updateKeys(canBePressed);
        this.updateArea(inputPointers, canBePressed);
        this.updateHover(inputPointers, cursorShown, inputMan, cmp);
        if (this.isWithSound && this.isJustOff()) {
            inputMan.playClick(cmp);
        }
        if (this.warnCount > 0) {
            --this.warnCount;
        }
    }

    private void updateHover(SolInputManager.InputPointer[] inputPointers, boolean cursorShown, SolInputManager inputMan, SolApplication cmp) {
        if (this.screenArea == null || this.isAreaPressed || inputPointers[0].pressed) {
            return;
        }
        boolean prev = this.doesMouseHover;
        boolean bl = this.doesMouseHover = cursorShown && this.screenArea.contains(inputPointers[0].x, inputPointers[0].y);
        if (this.isWithSound && this.doesMouseHover && !prev) {
            inputMan.playHover(cmp);
        }
    }

    private void updateKeys(boolean canBePressed) {
        this.wasKeyPressed = this.isKeyPressed;
        if (this.isKeyFlashed) {
            this.isKeyPressed = true;
            this.isKeyFlashed = false;
        } else {
            this.isKeyPressed = false;
            if (canBePressed) {
                for (int key : this.keys) {
                    if (!Gdx.input.isKeyPressed(key)) continue;
                    this.isKeyPressed = true;
                    break;
                }
            }
        }
    }

    private void updateArea(SolInputManager.InputPointer[] inputPointers, boolean canBePressed) {
        if (this.screenArea == null) {
            return;
        }
        this.isAreaJustUnpressed = false;
        if (this.isAreaFlashed) {
            this.isAreaPressed = true;
            this.isAreaFlashed = false;
        } else {
            this.isAreaPressed = false;
            if (canBePressed) {
                for (SolInputManager.InputPointer inputPointer : inputPointers) {
                    if (!this.screenArea.contains(inputPointer.x, inputPointer.y)) continue;
                    this.isAreaPressed = inputPointer.pressed;
                    this.isAreaJustUnpressed = !inputPointer.pressed && inputPointer.prevPressed;
                    break;
                }
            }
        }
    }

    public boolean isOn() {
        return this.isEnabled && (this.isKeyPressed || this.isAreaPressed);
    }

    public boolean isJustOff() {
        return this.isEnabled && (!this.isKeyPressed && this.wasKeyPressed || this.isAreaJustUnpressed);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void drawButton(UiDrawer uiDrawer, Color warnCol) {
        if (this.screenArea == null) {
            return;
        }
        Color tint = SolColor.UI_INACTIVE;
        if (this.isEnabled) {
            tint = this.isOn() ? SolColor.UI_LIGHT : (this.doesMouseHover ? SolColor.UI_MED : SolColor.UI_DARK);
        }
        uiDrawer.draw(this.screenArea, tint);
        if (this.warnCount > 0) {
            uiDrawer.draw(this.screenArea, warnCol);
        }
    }

    public void drawDisplayName(UiDrawer uiDrawer) {
        if (this.screenArea == null) {
            return;
        }
        Color tint = this.isEnabled ? SolColor.WHITE : SolColor.G;
        uiDrawer.drawString(this.displayName, this.screenArea.x + this.screenArea.width / 2.0f, this.screenArea.y + this.screenArea.height / 2.0f, 1.0f, true, tint);
    }

    public void blur() {
        this.isKeyPressed = false;
        this.wasKeyPressed = false;
        this.isAreaPressed = false;
        this.isAreaJustUnpressed = false;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public Rectangle getScreenArea() {
        return this.screenArea;
    }

    public boolean isMouseHover() {
        return this.doesMouseHover;
    }

    public void enableWarn() {
        this.warnCount = 2;
    }

    public void computePosition() {
        if (this.referencePosition == null) {
            return;
        }
        DisplayDimensions displayDimensions = SolApplication.displayDimensions;
        int x = this.referencePosition.getX() + this.offsetX - this.width / 2;
        int y = this.referencePosition.getY() + this.offsetY - this.height / 2;
        this.screenArea = new Rectangle((float)x * displayDimensions.getRatio() / (float)displayDimensions.getWidth(), (float)y / (float)displayDimensions.getHeight(), (float)this.width * displayDimensions.getRatio() / (float)displayDimensions.getWidth(), (float)this.height / (float)displayDimensions.getHeight());
    }
}

