/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.ui;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.ui.UiDrawer;

public class SolUiSlider {
    private static final float HANDLE_SCALE = 0.0125f;
    private static final TextureAtlas.AtlasRegion sliderTexture = Assets.getAtlasRegion("engine:ui/slider");
    private static final TextureAtlas.AtlasRegion sliderMarkerTexture = Assets.getAtlasRegion("engine:ui/sliderMarker");
    private final Rectangle rectangle;
    private float value;
    private String text;
    private final int trimAt;

    public SolUiSlider(Rectangle sliderRectangle, String text, float startingValue, int trimAt) {
        this.rectangle = sliderRectangle;
        this.value = SolMath.clamp(this.value);
        this.text = text;
        this.trimAt = trimAt;
    }

    public void draw(UiDrawer uiDrawer) {
        uiDrawer.draw(this.rectangle, SolColor.UI_INACTIVE);
        uiDrawer.draw((TextureRegion)sliderTexture, this.rectangle.width, this.rectangle.height, 0.0f, 0.0f, this.rectangle.x, this.rectangle.y, 0.0f, SolColor.WHITE);
        uiDrawer.setTextMode(true);
        String trimmedValue = Float.toString(this.value);
        int length = trimmedValue.substring(trimmedValue.indexOf(46)).length();
        if (length > this.trimAt) {
            String leftSubstring = trimmedValue.substring(0, trimmedValue.indexOf(46));
            String rightSubstring = trimmedValue.substring(trimmedValue.indexOf(46), leftSubstring.length() + 1 + this.trimAt);
            trimmedValue = leftSubstring + rightSubstring;
        }
        uiDrawer.drawString(this.text + trimmedValue, this.rectangle.x + this.rectangle.width * 0.5f, this.rectangle.y + this.rectangle.height * 0.5f, 1.0f, true, SolColor.WHITE);
        uiDrawer.setTextMode(false);
        uiDrawer.draw((TextureRegion)sliderMarkerTexture, this.rectangle.width * 0.0125f, this.rectangle.height, this.rectangle.width * 0.0125f * 0.5f, 0.0f, this.rectangle.x + this.value * this.rectangle.width, this.rectangle.y, 0.0f, SolColor.WHITE);
    }

    public boolean click(Vector2 clickPosition) {
        if (clickPosition.x > this.rectangle.x && clickPosition.x < this.rectangle.x + this.rectangle.width && clickPosition.y > this.rectangle.y && clickPosition.y < this.rectangle.y + this.rectangle.height) {
            float relativePos = clickPosition.x - this.rectangle.x;
            this.setValue(relativePos / this.rectangle.width);
            return true;
        }
        return false;
    }

    public void setValue(float val) {
        this.value = SolMath.clamp(val);
    }

    public float getValue() {
        return this.value;
    }
}

