/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.ui;

import com.badlogic.gdx.math.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.UpdateAwareSystem;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.screens.GameScreens;
import org.destinationsol.game.screens.InventoryScreen;
import org.destinationsol.game.screens.MainGameScreen;
import org.destinationsol.game.screens.ShipKbControl;
import org.destinationsol.game.screens.ShipMixedControl;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.UiDrawer;

public class TutorialManager
implements UpdateAwareSystem {
    private DisplayDimensions displayDimensions = SolApplication.displayDimensions;
    private final Rectangle background;
    private final ArrayList<Step> steps;
    private int stepIndex;

    public TutorialManager(GameScreens screens, boolean mobile, GameOptions gameOptions, SolGame game) {
        SolUiControl abilityCtrl;
        SolUiControl leftCtrl;
        SolUiControl upCtrl;
        String shootKey2;
        String shootKey;
        SolUiControl shootCtrl;
        float backgroundW = this.displayDimensions.getRatio() * 0.5f;
        float backgroundH = 0.2f;
        this.background = new Rectangle(this.displayDimensions.getRatio() / 2.0f - backgroundW / 2.0f, 1.0f - backgroundH, backgroundW, backgroundH);
        this.steps = new ArrayList();
        this.stepIndex = 0;
        MainGameScreen main = screens.mainGameScreen;
        boolean mouseCtrl = main.shipControl instanceof ShipMixedControl;
        if (mouseCtrl) {
            ShipMixedControl mixedControl = (ShipMixedControl)main.shipControl;
            shootCtrl = mixedControl.shootCtrl;
            shootKey = "(LEFT mouse button)";
            shootKey2 = "(Click LEFT mouse button)";
            upCtrl = mixedControl.upCtrl;
            leftCtrl = null;
            abilityCtrl = mixedControl.abilityCtrl;
        } else {
            ShipKbControl kbControl = (ShipKbControl)main.shipControl;
            shootCtrl = kbControl.shootCtrl;
            upCtrl = kbControl.upCtrl;
            leftCtrl = kbControl.leftCtrl;
            abilityCtrl = kbControl.abilityCtrl;
            if (mobile) {
                shootKey = "(GUN 1 button)";
                shootKey2 = "(Press GUN 1 button)";
            } else {
                shootKey = "(" + gameOptions.getKeyShootName() + " key)";
                shootKey2 = "(Press " + gameOptions.getKeyShootName() + " key)";
            }
        }
        this.addStep("Hi! Shoot your main gun\n" + shootKey, shootCtrl);
        if (leftCtrl != null) {
            if (mobile) {
                this.addStep("Great! Turn left.\nDon't fly away yet!", leftCtrl);
            } else {
                this.addStep("Great! Turn left (" + gameOptions.getKeyLeftName() + " key). \nDon't fly away yet!", leftCtrl);
            }
        }
        if (mobile) {
            this.addStep("Have a look at the map", main.mapControl, true);
        } else {
            this.addStep("Have a look at the map\n(" + gameOptions.getKeyMapName() + " key)", main.mapControl, true);
        }
        if (mouseCtrl) {
            this.addStep("Zoom in the map\n(mouse wheel UP)", screens.mapScreen.zoomInControl);
        } else if (mobile) {
            this.addStep("Zoom in the map", screens.mapScreen.zoomInControl);
        } else {
            this.addStep("Zoom in the map\n(" + gameOptions.getKeyZoomInName() + " key)", screens.mapScreen.zoomInControl);
        }
        if (mobile) {
            this.addStep("Close the map", screens.mapScreen.closeControl, true);
        } else {
            this.addStep("Close the map\n(" + gameOptions.getKeyMapName() + " or " + gameOptions.getKeyCloseName() + " keys)", screens.mapScreen.closeControl, true);
        }
        if (mouseCtrl || mobile) {
            this.addStep("Have a look\nat your inventory", main.inventoryControl, true);
        } else {
            this.addStep("Have a look\nat your inventory (" + gameOptions.getKeyInventoryName() + " key)", main.inventoryControl, true);
        }
        if (mouseCtrl || mobile) {
            this.addStep("In the inventory,\nselect the second row", screens.inventoryScreen.itemControls[1]);
        } else {
            this.addStep("In the inventory,\nselect the next item (" + gameOptions.getKeyDownName() + " key)", screens.inventoryScreen.downControl);
        }
        if (mouseCtrl || mobile) {
            this.addStep("Go to the next page", screens.inventoryScreen.nextControl, true);
        } else {
            this.addStep("Go to the next page\n(" + gameOptions.getKeyRightName() + " key)", screens.inventoryScreen.nextControl, true);
        }
        if (mouseCtrl || mobile) {
            this.addStep("Throw away some item\nyou don't use", screens.inventoryScreen.showInventory.dropControl);
        } else {
            this.addStep("Throw away some item\nyou don't use (" + gameOptions.getKeyDropName() + " key)", screens.inventoryScreen.showInventory.dropControl);
        }
        if (screens.inventoryScreen.getSelectedItem() == null || screens.inventoryScreen.getSelectedItem() != null && screens.inventoryScreen.getSelectedItem().isEquipped() == 0) {
            this.addStep(new SelectEquippedItemStep("Select an equipped item\n(note the text \"using\")", screens.inventoryScreen, game));
        }
        if (mobile) {
            this.addStep("Unequip the item\nthat is used now", screens.inventoryScreen.showInventory.eq1Control);
        } else {
            this.addStep("Unequip the item\nthat is used now (" + gameOptions.getKeyEquipName() + " key)", screens.inventoryScreen.showInventory.eq1Control);
        }
        if (mobile) {
            this.addStep("Now equip it again", screens.inventoryScreen.showInventory.eq1Control);
        } else {
            this.addStep("Now equip it again\n(" + gameOptions.getKeyEquipName() + " key)", screens.inventoryScreen.showInventory.eq1Control);
        }
        if (mobile) {
            this.addStep("Close the inventory\n(Touch the screen outside inventory)", screens.inventoryScreen.closeControl, true);
        } else {
            this.addStep("Close the inventory (" + gameOptions.getKeyCloseName() + " key)", screens.inventoryScreen.closeControl, true);
        }
        if (mouseCtrl) {
            this.addStep("Move forward (" + gameOptions.getKeyUpMouseName() + " key).\nThere's no stop!", upCtrl);
        } else if (mobile) {
            this.addStep("Move forward.\nThere's no stop!", upCtrl);
        } else {
            this.addStep("Move forward (" + gameOptions.getKeyUpName() + " key).\nThere's no stop!", upCtrl);
        }
        if (mobile) {
            this.addStep("Fly closer to the station\nand talk with it", main.talkControl, true);
        } else {
            this.addStep("Fly closer to the station\nand talk with it (" + gameOptions.getKeyTalkName() + " key)", main.talkControl, true);
        }
        if (mouseCtrl || mobile) {
            this.addStep("See what there is to buy", screens.talkScreen.buyControl, true);
        } else {
            this.addStep("See what there is to buy\n(" + gameOptions.getKeyBuyMenuName() + " key)", screens.talkScreen.buyControl, true);
        }
        if (mobile) {
            this.addStep("Buy some item", screens.inventoryScreen.buyItemsScreen.buyControl);
        } else {
            this.addStep("Buy some item\n(" + gameOptions.getKeyBuyItemName() + " key)", screens.inventoryScreen.buyItemsScreen.buyControl);
        }
        if (mobile) {
            this.addStep("Close the Buy screen\n(Touch the screen outside inventory)", screens.inventoryScreen.closeControl, true);
        } else {
            this.addStep("Close the Buy screen\n(" + gameOptions.getKeyCloseName() + " key)", screens.inventoryScreen.closeControl, true);
        }
        if (mouseCtrl) {
            this.addStep("Use the ability of your ship\n(MIDDLE mouse button or " + gameOptions.getKeyAbilityName() + " key)", abilityCtrl, true);
        } else if (mobile) {
            this.addStep("Use the ability of your ship", abilityCtrl, true);
        } else {
            this.addStep("Use the ability of your ship\n(" + gameOptions.getKeyAbilityName() + " key)", abilityCtrl, true);
        }
        this.addStep("Here's a couple of hints...\n" + shootKey2, shootCtrl);
        this.addStep("Enemies are orange icons, allies are blue\n" + shootKey2, shootCtrl);
        this.addStep("Avoid enemies with skull icon\n" + shootKey2, shootCtrl);
        this.addStep("To repair, have repair kits and just stay idle\n" + shootKey2, shootCtrl);
        this.addStep("Destroy asteroids to find money\n" + shootKey2, shootCtrl);
        this.addStep("Find or buy shields, armor, guns; equip them\n" + shootKey2, shootCtrl);
        this.addStep("Buy new ships, hire mercenaries\n" + shootKey2, shootCtrl);
        this.addStep("Tutorial is complete and will exit now!\n" + shootKey2, shootCtrl);
    }

    private void addStep(String text, SolUiControl ctrl) {
        this.addStep(text, ctrl, false);
    }

    private void addStep(String text, SolUiControl ctrl, boolean checkOn) {
        this.steps.add(new Step(text, ctrl, checkOn));
    }

    private void addStep(Step step) {
        this.steps.add(step);
    }

    @Override
    public void update(SolGame game, float timeStep) {
        Step step = this.steps.get(this.stepIndex);
        step.highlight();
        if (step.canProgressToNextStep()) {
            ++this.stepIndex;
        }
    }

    public void draw(UiDrawer uiDrawer) {
        if (this.isFinished()) {
            return;
        }
        Step step = this.steps.get(this.stepIndex);
        uiDrawer.draw(this.background, SolColor.UI_BG_LIGHT);
        uiDrawer.drawLine(this.background.x, this.background.y, 0.0f, this.background.width, SolColor.WHITE);
        uiDrawer.drawLine(this.background.x + this.background.width, this.background.y, 90.0f, this.background.height, SolColor.WHITE);
        uiDrawer.drawLine(this.background.x, this.background.y, 90.0f, this.background.height, SolColor.WHITE);
        uiDrawer.drawString(step.text, this.displayDimensions.getRatio() / 2.0f, this.background.y + this.background.height / 2.0f, 1.3f, true, SolColor.WHITE);
    }

    public boolean isFinished() {
        return this.stepIndex == this.steps.size();
    }

    public static class SelectEquippedItemStep
    extends Step {
        InventoryScreen inventoryScreen;
        SolGame game;

        public SelectEquippedItemStep(String text, InventoryScreen inventoryScreen, SolGame game) {
            super(text, null, true);
            this.inventoryScreen = inventoryScreen;
            this.game = game;
        }

        @Override
        public boolean canProgressToNextStep() {
            SolItem selected = this.inventoryScreen.getSelectedItem();
            return selected != null && selected.isEquipped() != 0;
        }

        @Override
        public void highlight() {
            List<SolUiControl> equippedItemControls = this.inventoryScreen.getEquippedItemUIControlsForTutorial(this.game);
            for (SolUiControl control : equippedItemControls) {
                control.enableWarn();
            }
        }
    }

    public static class Step {
        public final String text;
        public final SolUiControl ctrl;
        public final boolean checkOn;

        public Step(String text, SolUiControl ctrl, boolean checkOn) {
            this.text = text;
            this.ctrl = ctrl;
            this.checkOn = checkOn;
        }

        public void highlight() {
            if (this.ctrl != null) {
                this.ctrl.enableWarn();
            }
        }

        public boolean canProgressToNextStep() {
            if (this.checkOn) {
                return this.ctrl.isOn();
            }
            return this.ctrl.isJustOff();
        }
    }
}

