/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import java.util.HashMap;
import java.util.Map;
import org.destinationsol.CommonDrawer;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.Position;
import org.destinationsol.ui.ResizeSubscriber;

public class UiDrawer
implements ResizeSubscriber {
    public static final float FONT_SIZE = 0.02f;
    private Matrix4 straightMtx;
    private final float uiLineWidth;
    public static final TextureRegion whiteTexture = Assets.getAtlasRegion("engine:uiWhiteTex");
    public final Rectangle filler;
    private final CommonDrawer drawer;
    private Boolean isTextMode;
    private DisplayDimensions displayDimensions = SolApplication.displayDimensions;
    public static Map<String, Position> positions = new HashMap<String, Position>();

    public UiDrawer(CommonDrawer commonDrawer) {
        this.drawer = commonDrawer;
        this.uiLineWidth = 1.0f / (float)this.displayDimensions.getHeight();
        this.recomputeStraightMtx();
        this.drawer.setMatrix(this.straightMtx);
        this.filler = new Rectangle(0.0f, 0.0f, this.displayDimensions.getRatio(), 1.0f);
        positions.put("top", new Position(0.5f, 0.0f));
        positions.put("topRight", new Position(1.0f, 0.0f));
        positions.put("right", new Position(1.0f, 0.5f));
        positions.put("bottomRight", new Position(1.0f, 1.0f));
        positions.put("bottom", new Position(0.5f, 1.0f));
        positions.put("bottomLeft", new Position(0.0f, 1.0f));
        positions.put("left", new Position(0.0f, 0.5f));
        positions.put("topLeft", new Position(0.0f, 0.0f));
        positions.put("center", new Position(0.5f, 0.5f));
        SolApplication.addResizeSubscriber(this);
    }

    public void updateMtx() {
        this.setMatrix(this.straightMtx);
    }

    public void setMatrix(Matrix4 matrix) {
        this.drawer.setMatrix(matrix);
    }

    public void drawString(String s, float x, float y, float scale, boolean centered, Color tint) {
        this.drawString(s, x, y, scale, TextAlignment.CENTER, centered, tint);
    }

    public void drawString(String s, float x, float y, float scale, TextAlignment align, boolean centered, Color tint) {
        if (this.isTextMode != null && !this.isTextMode.booleanValue()) {
            throw new AssertionError((Object)"drawing text in atlas mode");
        }
        this.drawer.drawString(s, x, y, scale * 0.02f, align, centered, tint);
    }

    private void check() {
        if (this.isTextMode != null && this.isTextMode.booleanValue()) {
            throw new AssertionError((Object)"drawing atlas in text mode");
        }
    }

    public void draw(TextureRegion tr, float width, float height, float origX, float origY, float x, float y, float rot, Color tint) {
        this.check();
        this.drawer.draw(tr, width, height, origX, origY, x, y, rot, tint);
    }

    public void draw(Rectangle rect, Color tint) {
        this.check();
        this.drawer.draw(whiteTexture, rect, tint);
    }

    public void drawCircle(Vector2 center, float radius, Color col) {
        this.check();
        this.drawer.drawCircle(whiteTexture, center, radius, col, this.uiLineWidth, 1.0f);
    }

    public void drawLine(float x, float y, float angle, float len, Color col) {
        this.check();
        this.drawer.drawLine(whiteTexture, x, y, angle, len, col, this.uiLineWidth);
    }

    public void drawLine(Vector2 p1, Vector2 p2, Color col) {
        this.check();
        this.drawer.drawLine(whiteTexture, p1, p2, col, this.uiLineWidth, false);
    }

    public void setTextMode(Boolean textMode) {
        this.isTextMode = textMode;
    }

    @Override
    public void resize() {
        this.recomputeStraightMtx();
    }

    private void recomputeStraightMtx() {
        this.straightMtx = new Matrix4().setToOrtho2D(0.0f, 1.0f, this.displayDimensions.getRatio(), -1.0f);
    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

