/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;

public class Waypoint
implements SolObject {
    public final Vector2 position;
    public final Color color;
    public ArrayList<Drawable> drawables = new ArrayList();

    public Waypoint(Vector2 position, Color color, TextureAtlas.AtlasRegion waypointTexture) {
        this.position = position;
        this.color = color;
        this.drawables.add(new RectSprite(waypointTexture, 0.3f, 0.0f, 0.5f, new Vector2(), DrawableLevel.BODIES, 0.0f, 0.0f, this.color, true));
    }

    @Override
    public void update(SolGame game) {
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return false;
    }

    @Override
    public void onRemove(SolGame game) {
    }

    @Override
    public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
    }

    @Override
    public boolean receivesGravity() {
        return false;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public FarObject toFarObject() {
        FarObject farObject = new FarObject(){

            @Override
            public boolean shouldBeRemoved(SolGame game) {
                return false;
            }

            @Override
            public SolObject toObject(SolGame game) {
                for (Waypoint waypoint : game.getHero().getWaypoints()) {
                    if (!waypoint.position.equals((Object)Waypoint.this.position)) continue;
                    return waypoint;
                }
                return null;
            }

            @Override
            public void update(SolGame game) {
            }

            @Override
            public float getRadius() {
                return 0.0f;
            }

            @Override
            public Vector2 getPosition() {
                return Waypoint.this.position;
            }

            @Override
            public String toDebugString() {
                return "Waypoint";
            }

            @Override
            public boolean hasBody() {
                return false;
            }
        };
        return farObject;
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Override
    public float getAngle() {
        return 0.0f;
    }

    @Override
    public Vector2 getVelocity() {
        return null;
    }

    @Override
    public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
    }

    @Override
    public Boolean isMetal() {
        return null;
    }

    @Override
    public boolean hasBody() {
        return true;
    }
}

