/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.util;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CamelCaseMatcher {
    private CamelCaseMatcher() {
    }

    public static Set<String> getMatches(String queryStr, Collection<String> commands, boolean includeCaseInsensitiveStartingWith) {
        HashSet matches = Sets.newHashSet();
        String query = queryStr.replaceAll("\\*", ".*?");
        query = query.replaceAll("\\(|\\)|\\[|\\]|\\{|\\}", "");
        query = query.replaceFirst("\\b([a-z]+)", "$1[a-z]*");
        String re = "\\b(" + query.replaceAll("([A-Z][^A-Z]*)", "$1[^A-Z]*") + ".*?)\\b";
        Pattern regex = Pattern.compile(re);
        for (String cmd : commands) {
            Matcher m;
            if (includeCaseInsensitiveStartingWith && cmd.toLowerCase().startsWith(queryStr.toLowerCase())) {
                matches.add(cmd);
            }
            if (!(m = regex.matcher(cmd)).find()) continue;
            matches.add(m.group());
        }
        return matches;
    }
}

