/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CircularBuffer<T>
extends AbstractList<T> {
    private final T[] buffer;
    private int startIndex;
    private int occupancy;

    private CircularBuffer(int length) {
        this.buffer = new Object[length];
    }

    public static <T> CircularBuffer<T> create(int length) {
        return new CircularBuffer<T>(length);
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.occupancy) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.calculateIndex(index)];
    }

    @Override
    public T set(int index, T element) {
        if (index < 0 || index >= this.occupancy) {
            throw new IndexOutOfBoundsException();
        }
        int bufIndex = this.calculateIndex(index);
        T prev = this.buffer[bufIndex];
        this.buffer[bufIndex] = element;
        return prev;
    }

    @Override
    public T getLast() {
        return this.get(this.occupancy - 1);
    }

    @Override
    public boolean add(T item) {
        this.buffer[(this.startIndex + this.occupancy) % this.buffer.length] = item;
        if (this.occupancy < this.buffer.length) {
            ++this.occupancy;
        } else {
            this.startIndex = (this.startIndex + 1) % this.buffer.length;
        }
        return true;
    }

    @Override
    public T remove(int idx) {
        if (idx < 0 || idx >= this.occupancy) {
            throw new IndexOutOfBoundsException();
        }
        T old = this.buffer[this.calculateIndex(idx)];
        for (int i = idx; i < this.occupancy - 1; ++i) {
            int thisIdx = this.calculateIndex(i);
            int nextIdx = this.calculateIndex(i + 1);
            this.buffer[thisIdx] = this.buffer[nextIdx];
        }
        this.buffer[this.calculateIndex((int)(this.occupancy - 1))] = null;
        --this.occupancy;
        return old;
    }

    @Override
    public T getFirst() {
        return this.buffer[this.startIndex];
    }

    public T popFirst() {
        T result = this.buffer[this.startIndex];
        this.buffer[this.startIndex] = null;
        ++this.startIndex;
        --this.occupancy;
        return result;
    }

    public T popLast() {
        int index = this.calculateIndex(this.occupancy - 1);
        T result = this.buffer[index];
        this.buffer[index] = null;
        --this.occupancy;
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.occupancy;
    }

    public int capacity() {
        return this.buffer.length;
    }

    private int calculateIndex(int relativeIndex) {
        return (relativeIndex + this.startIndex) % this.buffer.length;
    }

    @Override
    public Iterator<T> iterator() {
        return new BufferIterator();
    }

    @Override
    public void clear() {
        this.occupancy = 0;
        this.startIndex = 0;
    }

    private class BufferIterator
    implements Iterator<T> {
        private int index;
        private int prevIndex = -1;

        private BufferIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < CircularBuffer.this.occupancy;
        }

        @Override
        public T next() {
            if (this.index >= CircularBuffer.this.occupancy) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.index;
            return CircularBuffer.this.get(this.index++);
        }

        @Override
        public void remove() {
            if (this.prevIndex < 0) {
                throw new IllegalStateException();
            }
            CircularBuffer.this.remove(this.prevIndex);
            this.index = this.prevIndex;
            this.prevIndex = -1;
        }
    }
}

