/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.util;

public class FramerateLimiter {
    protected static long variableYieldTime;
    protected static long lastTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void synchronizeFPS(int fps) {
        if (fps <= 0) {
            return;
        }
        long sleepTime = 1000000000 / fps;
        long yieldTime = Math.min(sleepTime, variableYieldTime + sleepTime % 1000000L);
        long overSleep = 0L;
        try {
            long t;
            while (true) {
                if ((t = System.nanoTime() - lastTime) < sleepTime - yieldTime) {
                    Thread.sleep(1L);
                    continue;
                }
                if (t >= sleepTime) break;
                Thread.yield();
            }
            overSleep = t - sleepTime;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            lastTime = System.nanoTime() - Math.min(overSleep, sleepTime);
            if (overSleep > variableYieldTime) {
                variableYieldTime = Math.min(variableYieldTime + 200000L, sleepTime);
            } else if (overSleep < variableYieldTime - 200000L) {
                variableYieldTime = Math.max(variableYieldTime - 2000L, 0L);
            }
        }
    }
}

