/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.util;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Optional;
import org.destinationsol.common.In;
import org.destinationsol.game.context.Context;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.util.reflection.ParameterProvider;
import org.terasology.gestalt.util.reflection.SimpleClassFactory;

public final class InjectionHelper {
    private static final Logger logger = LoggerFactory.getLogger(InjectionHelper.class);

    private InjectionHelper() {
    }

    public static void inject(Object object, Context context) {
        AccessController.doPrivileged(() -> {
            for (Field field : ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(In.class)})) {
                Object value = context.get(field.getType());
                if (value == null) continue;
                try {
                    field.setAccessible(true);
                    field.set(object, value);
                }
                catch (IllegalAccessException e) {
                    logger.error("Failed to inject value {} into field {} of {}", new Object[]{value, field, object, e});
                }
            }
            return null;
        });
    }

    public static <E> E createWithConstructorInjection(Class<? extends E> clazz, Context context) {
        return InjectionHelper.safeCreateWithConstructorInjection(clazz, context).get();
    }

    public static <E> Optional<E> safeCreateWithConstructorInjection(Class<? extends E> clazz, final Context context) {
        SimpleClassFactory simpleClassFactory = new SimpleClassFactory(new ParameterProvider(){

            public <T> Optional<T> get(Class<T> x) {
                return Optional.ofNullable(context.get(x));
            }
        });
        return simpleClassFactory.instantiateClass(clazz);
    }
}

