/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class SpecificAccessibleObject<T extends AccessibleObject> {
    private T accessibleObject;
    private Object target;

    public SpecificAccessibleObject(T accessibleObject, Object target) {
        Preconditions.checkNotNull(accessibleObject);
        Preconditions.checkNotNull((Object)target);
        this.accessibleObject = accessibleObject;
        this.target = target;
    }

    public static SpecificAccessibleObject<Method> method(Object target, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Class<?> targetClass = target.getClass();
        Method method = targetClass.getMethod(name, parameterTypes);
        return new SpecificAccessibleObject<Method>(method, target);
    }

    public static SpecificAccessibleObject<Field> field(Object target, String name) throws NoSuchFieldException {
        Class<?> targetClass = target.getClass();
        Field field = targetClass.getField(name);
        return new SpecificAccessibleObject<Field>(field, target);
    }

    public static SpecificAccessibleObject<Method> declaredMethod(Object target, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Class<?> targetClass = target.getClass();
        Method method = targetClass.getDeclaredMethod(name, parameterTypes);
        return new SpecificAccessibleObject<Method>(method, target);
    }

    public static SpecificAccessibleObject<Field> declaredField(Object target, String name) throws NoSuchFieldException {
        Class<?> targetClass = target.getClass();
        Field field = targetClass.getDeclaredField(name);
        return new SpecificAccessibleObject<Field>(field, target);
    }

    public Object getTarget() {
        return this.target;
    }

    public T getAccessibleObject() {
        return this.accessibleObject;
    }
}

