/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets;

import android.support.annotation.Nullable;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.terasology.gestalt.assets.Asset;
import org.terasology.gestalt.assets.AssetData;
import org.terasology.gestalt.assets.AssetDataProducer;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.management.AssetManager;
import org.terasology.gestalt.module.sandbox.API;
import org.terasology.gestalt.naming.Name;

@API
public abstract class AbstractFragmentDataProducer<T extends AssetData, U extends Asset<V>, V extends AssetData>
implements AssetDataProducer<T> {
    private final AssetManager assetManager;
    private final Class<U> rootAssetType;
    private final boolean resolveModuleFromRoot;

    protected AbstractFragmentDataProducer(AssetManager assetManager, Class<U> rootAssetType, boolean resolveModuleFromRoot) {
        this.assetManager = assetManager;
        this.rootAssetType = rootAssetType;
        this.resolveModuleFromRoot = resolveModuleFromRoot;
    }

    @Override
    public Set<Name> getModulesProviding(Name resourceName) {
        if (this.resolveModuleFromRoot) {
            return ImmutableSet.copyOf((Collection)Collections2.transform(this.assetManager.resolve(resourceName.toString(), this.rootAssetType), (Function)new Function<ResourceUrn, Name>(){

                @Nullable
                public Name apply(ResourceUrn input) {
                    return input.getModuleName();
                }
            }));
        }
        return Collections.emptySet();
    }

    @Override
    public ResourceUrn redirect(ResourceUrn urn) {
        return urn;
    }

    @Override
    public Optional<T> getAssetData(ResourceUrn urn) throws IOException {
        Optional<U> rootAsset = this.assetManager.getAsset(urn.getRootUrn(), this.rootAssetType);
        if (rootAsset.isPresent()) {
            return this.getFragmentData(urn, (Asset)rootAsset.get());
        }
        return Optional.empty();
    }

    protected abstract Optional<T> getFragmentData(ResourceUrn var1, U var2);
}

