/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.jcip.annotations.ThreadSafe;
import org.terasology.gestalt.assets.AssetData;
import org.terasology.gestalt.assets.AssetType;
import org.terasology.gestalt.assets.DisposableResource;
import org.terasology.gestalt.assets.DisposalHook;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.module.sandbox.API;

@API
@ThreadSafe
public abstract class Asset<T extends AssetData> {
    private final ResourceUrn urn;
    private final AssetType<?, T> assetType;
    private final DisposalHook disposalHook = new DisposalHook();
    private volatile boolean disposed;

    public Asset(ResourceUrn urn, AssetType<?, T> assetType) {
        Preconditions.checkNotNull((Object)urn);
        Preconditions.checkNotNull(assetType);
        this.urn = urn;
        this.assetType = assetType;
        assetType.registerAsset(this, this.disposalHook);
    }

    public Asset(ResourceUrn urn, AssetType<?, T> assetType, DisposableResource resource) {
        Preconditions.checkNotNull((Object)urn);
        Preconditions.checkNotNull(assetType);
        this.urn = urn;
        this.assetType = assetType;
        this.disposalHook.setDisposableResource(resource);
        assetType.registerAsset(this, this.disposalHook);
    }

    public final ResourceUrn getUrn() {
        return this.urn;
    }

    public final synchronized void reload(T data) {
        if (this.disposed) {
            throw new IllegalStateException("Cannot reload disposed asset '" + this.getUrn() + "'");
        }
        this.doReload(data);
    }

    public final <U extends Asset<T>> Optional<U> createInstance() {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0);
        return this.assetType.createInstance(this);
    }

    final synchronized Optional<? extends Asset<T>> createCopy(ResourceUrn copyUrn) {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0);
        return this.doCreateCopy(copyUrn, this.assetType);
    }

    public final synchronized void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.assetType.onAssetDisposed(this);
            this.disposalHook.dispose();
        }
    }

    protected abstract void doReload(T var1);

    protected Optional<? extends Asset<T>> doCreateCopy(ResourceUrn copyUrn, AssetType<?, T> parentAssetType) {
        return Optional.empty();
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Asset) {
            Asset other = (Asset)obj;
            return !this.urn.isInstance() && !other.urn.isInstance() && other.urn.equals(this.urn);
        }
        return false;
    }

    public int hashCode() {
        return this.urn.hashCode();
    }

    public String toString() {
        return this.urn.toString();
    }
}

