/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets;

import android.support.annotation.Nullable;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.DisposableResource;

class DisposalHook {
    private static final Logger logger = LoggerFactory.getLogger(DisposalHook.class);
    private volatile DisposableResource resource;

    DisposalHook() {
    }

    synchronized void dispose() {
        if (this.resource != null) {
            this.resource.close();
        }
        this.resource = null;
    }

    void setDisposableResource(@Nullable DisposableResource resource) {
        Class<?> actionType;
        if (resource != null && ((actionType = resource.getClass()).isLocalClass() || actionType.isAnonymousClass() || actionType.isMemberClass()) && !Modifier.isStatic(actionType.getModifiers())) {
            logger.warn("Non-static anonymous or member class should not be registered as the disposable resource - this will block garbage collection enqueuing for disposal");
        }
        this.resource = resource;
    }
}

