/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.terasology.gestalt.assets.exceptions.InvalidUrnException;
import org.terasology.gestalt.module.sandbox.API;
import org.terasology.gestalt.naming.Name;

@API
public final class ResourceUrn
implements Comparable<ResourceUrn> {
    public static final String RESOURCE_SEPARATOR = ":";
    public static final String FRAGMENT_SEPARATOR = "#";
    public static final String INSTANCE_INDICATOR = "!instance";
    private static final Pattern URN_PATTERN = Pattern.compile("([^:]+):([^#!]+)(?:#([^!]+))?(!instance)?");
    private final Name moduleName;
    private final Name resourceName;
    private final Name fragmentName;
    private final boolean instance;

    public ResourceUrn(ResourceUrn urn, String fragmentName) {
        this(urn, new Name(fragmentName), false);
    }

    public ResourceUrn(ResourceUrn urn, Name fragmentName) {
        this(urn, fragmentName, false);
    }

    public ResourceUrn(ResourceUrn urn, String fragmentName, boolean instance) {
        this(urn, new Name(fragmentName), instance);
    }

    public ResourceUrn(ResourceUrn urn, Name fragmentName, boolean instance) {
        this.moduleName = urn.getModuleName();
        this.resourceName = urn.getResourceName();
        this.fragmentName = fragmentName;
        this.instance = instance;
    }

    public ResourceUrn(String moduleName, String resourceName) {
        this(new Name(moduleName), new Name(resourceName), false);
    }

    public ResourceUrn(String moduleName, String resourceName, boolean instance) {
        this(new Name(moduleName), new Name(resourceName), Name.EMPTY, instance);
    }

    public ResourceUrn(Name moduleName, Name resourceName) {
        this(moduleName, resourceName, Name.EMPTY, false);
    }

    public ResourceUrn(Name moduleName, Name resourceName, boolean instance) {
        this(moduleName, resourceName, Name.EMPTY, instance);
    }

    public ResourceUrn(String moduleName, String resourceName, String fragmentName) {
        this(new Name(moduleName), new Name(resourceName), new Name(fragmentName), false);
    }

    public ResourceUrn(String moduleName, String resourceName, String fragmentName, boolean instance) {
        this(new Name(moduleName), new Name(resourceName), new Name(fragmentName), instance);
    }

    public ResourceUrn(Name moduleName, Name resourceName, Name fragmentName) {
        this(moduleName, resourceName, fragmentName, false);
    }

    public ResourceUrn(Name moduleName, Name resourceName, Name fragmentName, boolean instance) {
        Preconditions.checkArgument((moduleName != null && !moduleName.isEmpty() ? 1 : 0) != 0, (Object)"moduleName must not be null or empty");
        Preconditions.checkArgument((resourceName != null && !resourceName.isEmpty() ? 1 : 0) != 0, (Object)"resourceName must not be null or empty");
        this.moduleName = moduleName;
        this.resourceName = resourceName;
        this.fragmentName = fragmentName;
        this.instance = instance;
    }

    public ResourceUrn(String urn) {
        Matcher match = URN_PATTERN.matcher(urn);
        if (!match.matches()) {
            throw new InvalidUrnException("Invalid Urn: '" + urn + "'");
        }
        this.moduleName = new Name(match.group(1));
        this.resourceName = new Name(match.group(2));
        this.fragmentName = !Strings.isNullOrEmpty((String)match.group(3)) ? new Name(match.group(3)) : Name.EMPTY;
        this.instance = !Strings.isNullOrEmpty((String)match.group(4));
    }

    public static boolean isValid(String urn) {
        return URN_PATTERN.matcher(urn).matches();
    }

    public Name getModuleName() {
        return this.moduleName;
    }

    public Name getResourceName() {
        return this.resourceName;
    }

    public Name getFragmentName() {
        return this.fragmentName;
    }

    public boolean isInstance() {
        return this.instance;
    }

    public ResourceUrn getRootUrn() {
        if (this.fragmentName.isEmpty() && !this.isInstance()) {
            return this;
        }
        return new ResourceUrn(this.moduleName, this.resourceName);
    }

    public ResourceUrn getParentUrn() {
        if (this.isInstance()) {
            return new ResourceUrn(this.moduleName, this.resourceName, this.fragmentName);
        }
        return this;
    }

    public ResourceUrn getInstanceUrn() {
        if (!this.isInstance()) {
            return new ResourceUrn(this.moduleName, this.resourceName, this.fragmentName, true);
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.moduleName);
        stringBuilder.append(RESOURCE_SEPARATOR);
        stringBuilder.append(this.resourceName);
        if (!this.fragmentName.isEmpty()) {
            stringBuilder.append(FRAGMENT_SEPARATOR);
            stringBuilder.append(this.fragmentName);
        }
        if (this.instance) {
            stringBuilder.append(INSTANCE_INDICATOR);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResourceUrn) {
            ResourceUrn other = (ResourceUrn)obj;
            return Objects.equal((Object)this.moduleName, (Object)other.moduleName) && Objects.equal((Object)this.resourceName, (Object)other.resourceName) && Objects.equal((Object)this.fragmentName, (Object)other.fragmentName) && this.instance == other.instance;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fragmentName, this.resourceName, this.moduleName});
    }

    @Override
    public int compareTo(ResourceUrn o) {
        int result = this.moduleName.compareTo(o.getModuleName());
        if (result == 0) {
            result = this.resourceName.compareTo(o.getResourceName());
        }
        if (result == 0) {
            result = this.fragmentName.compareTo(o.getFragmentName());
        }
        if (result == 0) {
            if (this.instance && !o.instance) {
                result = 1;
            } else if (!this.instance && o.instance) {
                result = -1;
            }
        }
        return result;
    }
}

