/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.format;

import java.util.List;
import java.util.function.Predicate;
import org.terasology.gestalt.assets.AssetData;
import org.terasology.gestalt.assets.exceptions.InvalidAssetFilenameException;
import org.terasology.gestalt.assets.format.AssetFileFormat;
import org.terasology.gestalt.assets.format.FileUtil;
import org.terasology.gestalt.module.resources.FileReference;
import org.terasology.gestalt.naming.Name;
import org.terasology.gestalt.util.Varargs;

public abstract class AbstractAssetFileFormat<T extends AssetData>
implements AssetFileFormat<T> {
    private Predicate<FileReference> fileMatcher;

    public AbstractAssetFileFormat(String fileExtension, String ... fileExtensions) {
        this.fileMatcher = FileUtil.createFileExtensionPredicate((List<String>)Varargs.combineToList((Object)fileExtension, (Object[])fileExtensions));
    }

    public AbstractAssetFileFormat(Predicate<FileReference> fileMatcher) {
        this.fileMatcher = fileMatcher;
    }

    @Override
    public Name getAssetName(String filename) throws InvalidAssetFilenameException {
        int extensionStart = filename.lastIndexOf(46);
        if (extensionStart != -1) {
            return new Name(filename.substring(0, extensionStart));
        }
        return new Name(filename);
    }

    @Override
    public Predicate<FileReference> getFileMatcher() {
        return this.fileMatcher;
    }
}

