/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.format;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import org.terasology.gestalt.module.resources.FileReference;

@Immutable
public class AssetDataFile {
    private final FileReference file;

    public AssetDataFile(FileReference file) {
        Preconditions.checkNotNull((Object)file);
        this.file = file;
    }

    public List<String> getPath() {
        return this.file.getPath();
    }

    public String getFilename() {
        return this.file.getName();
    }

    public String getFileExtension() {
        String filename = this.getFilename();
        if (filename.contains(".")) {
            return filename.substring(filename.lastIndexOf(".") + 1);
        }
        return "";
    }

    public InputStream openStream() throws IOException {
        try {
            return AccessController.doPrivileged(() -> ((FileReference)this.file).open());
        }
        catch (PrivilegedActionException e) {
            throw new IOException("Failed to open stream for '" + this.file + "'", e);
        }
    }

    public BufferedReader openReader() throws IOException {
        return this.openReader(Charsets.UTF_8);
    }

    public BufferedReader openReader(Charset charset) throws IOException {
        return new BufferedReader(new InputStreamReader(this.openStream(), charset));
    }

    public String toString() {
        return this.file.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AssetDataFile) {
            AssetDataFile other = (AssetDataFile)obj;
            return Objects.equals(other.file, this.file);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }
}

