/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.format.producer;

import com.google.common.base.Charsets;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.AssetData;
import org.terasology.gestalt.assets.AssetDataProducer;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.exceptions.InvalidAssetFilenameException;
import org.terasology.gestalt.assets.format.AssetAlterationFileFormat;
import org.terasology.gestalt.assets.format.AssetFileFormat;
import org.terasology.gestalt.assets.format.FileFormat;
import org.terasology.gestalt.assets.format.producer.FileChangeSubscriber;
import org.terasology.gestalt.assets.format.producer.ModuleDependencyProvider;
import org.terasology.gestalt.assets.format.producer.UnloadedAssetData;
import org.terasology.gestalt.module.resources.FileReference;
import org.terasology.gestalt.naming.Name;

@ThreadSafe
public class AssetFileDataProducer<U extends AssetData>
implements AssetDataProducer<U>,
FileChangeSubscriber {
    public static final String REDIRECT_EXTENSION = ".redirect";
    private static final Logger logger = LoggerFactory.getLogger(AssetFileDataProducer.class);
    private final ModuleDependencyProvider dependencyProvider;
    private final ImmutableList<String> folderNames;
    private final List<AssetFileFormat<U>> assetFormats;
    private final List<AssetAlterationFileFormat<U>> deltaFormats;
    private final List<AssetAlterationFileFormat<U>> supplementFormats;
    private final Map<ResourceUrn, UnloadedAssetData<U>> unloadedAssetLookup = new MapMaker().concurrencyLevel(1).makeMap();
    private final Map<ResourceUrn, ResourceUrn> redirectMap = new MapMaker().concurrencyLevel(1).makeMap();
    private final SetMultimap<ResourceUrn, ResourceUrn> redirectSourceMap = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final SetMultimap<Name, Name> resolutionMap = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    public AssetFileDataProducer(ModuleDependencyProvider dependencyProvider, String ... folderNames) {
        this(dependencyProvider, Arrays.asList(folderNames));
    }

    public AssetFileDataProducer(ModuleDependencyProvider dependencyProvider, Collection<String> folderNames) {
        this.folderNames = ImmutableList.copyOf(folderNames);
        this.dependencyProvider = dependencyProvider;
        this.assetFormats = Lists.newCopyOnWriteArrayList();
        this.supplementFormats = Lists.newCopyOnWriteArrayList();
        this.deltaFormats = Lists.newCopyOnWriteArrayList();
    }

    public List<AssetFileFormat<U>> getAssetFormats() {
        return Collections.unmodifiableList(this.assetFormats);
    }

    public void addAssetFormat(AssetFileFormat<U> format) {
        this.assetFormats.add(format);
    }

    public boolean removeAssetFormat(AssetFileFormat<U> format) {
        return this.assetFormats.remove(format);
    }

    public List<AssetAlterationFileFormat<U>> getSupplementFormats() {
        return Collections.unmodifiableList(this.supplementFormats);
    }

    public void addSupplementFormat(AssetAlterationFileFormat<U> format) {
        this.supplementFormats.add(format);
    }

    public boolean removeSupplementFormat(AssetAlterationFileFormat<U> format) {
        return this.supplementFormats.remove(format);
    }

    public List<AssetAlterationFileFormat<U>> getDeltaFormats() {
        return Collections.unmodifiableList(this.deltaFormats);
    }

    public void addDeltaFormat(AssetAlterationFileFormat<U> format) {
        this.deltaFormats.add(format);
    }

    public boolean removeDeltaFormat(AssetAlterationFileFormat<U> format) {
        return this.deltaFormats.remove(format);
    }

    @Override
    public Set<ResourceUrn> getAvailableAssetUrns() {
        return ImmutableSet.copyOf(this.unloadedAssetLookup.keySet());
    }

    @Override
    public Set<Name> getModulesProviding(Name resourceName) {
        return ImmutableSet.copyOf((Collection)this.resolutionMap.get((Object)resourceName));
    }

    @Override
    public ResourceUrn redirect(ResourceUrn urn) {
        ResourceUrn redirectUrn = this.redirectMap.get(urn);
        if (redirectUrn != null) {
            return redirectUrn;
        }
        return urn;
    }

    @Override
    public Optional<U> getAssetData(ResourceUrn urn) throws IOException {
        UnloadedAssetData<U> source;
        if (urn.getFragmentName().isEmpty() && (source = this.unloadedAssetLookup.get(urn)) != null && source.isValid()) {
            return source.load();
        }
        return Optional.empty();
    }

    private <V extends FileFormat> Optional<ResourceUrn> registerSource(Name module, FileReference target, Name providingModule, Collection<V> formats, RegisterSourceHandler<U, V> sourceHandler) {
        for (FileFormat format : formats) {
            if (!format.getFileMatcher().test(target)) continue;
            try {
                Name assetName = format.getAssetName(target.getName());
                ResourceUrn urn = new ResourceUrn(module, assetName);
                UnloadedAssetData<U> existing = this.unloadedAssetLookup.get(urn);
                if (existing != null) {
                    if (sourceHandler.registerSource(existing, providingModule, format, target)) {
                        return Optional.of(urn);
                    }
                } else {
                    UnloadedAssetData source = new UnloadedAssetData(urn, this.dependencyProvider);
                    if (sourceHandler.registerSource(source, providingModule, format, target)) {
                        this.unloadedAssetLookup.put(urn, source);
                        this.resolutionMap.put((Object)urn.getResourceName(), (Object)urn.getModuleName());
                        return Optional.of(urn);
                    }
                }
                return Optional.empty();
            }
            catch (InvalidAssetFilenameException e) {
                logger.warn("Invalid name for asset - {}", (Object)target);
            }
        }
        return Optional.empty();
    }

    private Optional<ResourceUrn> registerAssetDelta(Name module, FileReference target, Name providingModule) {
        for (AssetAlterationFileFormat<U> format : this.deltaFormats) {
            if (!format.getFileMatcher().test(target)) continue;
            try {
                Name assetName = format.getAssetName(target.getName());
                ResourceUrn urn = new ResourceUrn(module, assetName);
                UnloadedAssetData<U> unloadedAssetData = this.unloadedAssetLookup.get(urn);
                if (unloadedAssetData == null) {
                    logger.warn("Discovered delta for unknown asset '{}'", (Object)urn);
                    return Optional.empty();
                }
                if (!unloadedAssetData.addDeltaSource(providingModule, format, target)) continue;
                return Optional.of(urn);
            }
            catch (InvalidAssetFilenameException e) {
                logger.error("Invalid file name '{}' for asset delta", (Object)target, (Object)e);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<ResourceUrn> assetFileAdded(FileReference file, Name module, Name providingModule) {
        if (file.getName().endsWith(REDIRECT_EXTENSION)) {
            this.processRedirectFile(file, module);
        } else {
            Optional<ResourceUrn> urn = this.registerSource(module, file, providingModule, this.assetFormats, UnloadedAssetData::addSource);
            if (!urn.isPresent()) {
                urn = this.registerSource(module, file, providingModule, this.supplementFormats, UnloadedAssetData::addSupplementSource);
            }
            if (urn.isPresent() && this.unloadedAssetLookup.get(urn.get()).isValid()) {
                return urn;
            }
        }
        return Optional.empty();
    }

    private synchronized void processRedirectFile(FileReference file, Name moduleId) {
        Name assetName = new Name(Files.getNameWithoutExtension((String)file.getName()));
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.open(), Charsets.UTF_8));){
            List contents = CharStreams.readLines((Readable)reader);
            if (contents.isEmpty()) {
                logger.error("Failed to read redirect '{}:{}' - empty", (Object)moduleId, (Object)assetName);
            } else if (!ResourceUrn.isValid((String)contents.get(0))) {
                logger.error("Failed to read redirect '{}:{}' - '{}' is not a valid urn", new Object[]{moduleId, assetName, contents.get(0)});
            } else {
                ResourceUrn fromUrn = new ResourceUrn(moduleId, assetName);
                ResourceUrn toUrn = new ResourceUrn((String)contents.get(0));
                if (this.redirectMap.containsKey(toUrn)) {
                    toUrn = this.redirectMap.get(toUrn);
                }
                this.redirectMap.put(fromUrn, toUrn);
                this.redirectSourceMap.put((Object)toUrn, (Object)fromUrn);
                for (ResourceUrn furtherFromUrn : this.redirectSourceMap.get((Object)fromUrn)) {
                    this.redirectMap.put(furtherFromUrn, toUrn);
                    this.redirectSourceMap.put((Object)toUrn, (Object)furtherFromUrn);
                }
                this.redirectSourceMap.removeAll((Object)fromUrn);
                this.resolutionMap.put((Object)assetName, (Object)moduleId);
            }
        }
        catch (IOException e) {
            logger.error("Failed to read redirect '{}:{}'", new Object[]{moduleId, assetName, e});
        }
    }

    private Optional<ResourceUrn> getResourceUrn(FileReference target, Name module, Collection<? extends FileFormat> formats) {
        for (FileFormat fileFormat : formats) {
            if (!fileFormat.getFileMatcher().test(target)) continue;
            try {
                Name assetName = fileFormat.getAssetName(target.getName());
                return Optional.of(new ResourceUrn(module, assetName));
            }
            catch (InvalidAssetFilenameException e) {
                logger.debug("Modified file does not have a valid asset name - '{}'", (Object)target);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<ResourceUrn> assetFileModified(FileReference file, Name module, Name providingModule) {
        Optional<ResourceUrn> urn = this.getResourceUrn(file, module, this.assetFormats);
        if (!urn.isPresent()) {
            urn = this.getResourceUrn(file, module, this.supplementFormats);
        }
        if (urn.isPresent() && this.unloadedAssetLookup.get(urn.get()).isValid()) {
            return urn;
        }
        return Optional.empty();
    }

    @Override
    public Optional<ResourceUrn> assetFileDeleted(FileReference file, Name module, Name providingModule) {
        for (AssetFileFormat<U> assetFileFormat : this.assetFormats) {
            if (!assetFileFormat.getFileMatcher().test(file)) continue;
            try {
                Name assetName = assetFileFormat.getAssetName(file.getName());
                ResourceUrn urn = new ResourceUrn(module, assetName);
                UnloadedAssetData<U> existing = this.unloadedAssetLookup.get(urn);
                if (existing != null) {
                    existing.removeSource(providingModule, assetFileFormat, file);
                    if (existing.isValid()) {
                        return Optional.of(urn);
                    }
                }
                return Optional.empty();
            }
            catch (InvalidAssetFilenameException e) {
                logger.debug("Deleted file does not have a valid file name - {}", (Object)file);
            }
        }
        for (AssetAlterationFileFormat assetAlterationFileFormat : this.supplementFormats) {
            if (!assetAlterationFileFormat.getFileMatcher().test(file)) continue;
            try {
                Name assetName = assetAlterationFileFormat.getAssetName(file.getName());
                ResourceUrn urn = new ResourceUrn(module, assetName);
                UnloadedAssetData<U> existing = this.unloadedAssetLookup.get(urn);
                if (existing != null) {
                    existing.removeSupplementSource(providingModule, assetAlterationFileFormat, file);
                    if (existing.isValid()) {
                        return Optional.of(urn);
                    }
                }
                return Optional.empty();
            }
            catch (InvalidAssetFilenameException e) {
                logger.debug("Deleted file does not have a valid file name - {}", (Object)file);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<ResourceUrn> deltaFileAdded(FileReference file, Name module, Name providingModule) {
        Optional<ResourceUrn> urn = this.registerAssetDelta(module, file, providingModule);
        if (urn.isPresent() && this.unloadedAssetLookup.get(urn.get()).isValid()) {
            return urn;
        }
        return Optional.empty();
    }

    @Override
    public Optional<ResourceUrn> deltaFileModified(FileReference file, Name module, Name providingModule) {
        Optional<ResourceUrn> urn = this.getResourceUrn(file, module, this.deltaFormats);
        if (urn.isPresent() && this.unloadedAssetLookup.get(urn.get()).isValid()) {
            return urn;
        }
        return Optional.empty();
    }

    @Override
    public Optional<ResourceUrn> deltaFileDeleted(FileReference file, Name module, Name providingModule) {
        for (AssetAlterationFileFormat<U> format : this.deltaFormats) {
            if (!format.getFileMatcher().test(file)) continue;
            try {
                Name assetName = format.getAssetName(file.getName());
                ResourceUrn urn = new ResourceUrn(module, assetName);
                UnloadedAssetData<U> existing = this.unloadedAssetLookup.get(urn);
                if (existing != null) {
                    existing.removeDeltaSource(providingModule, format, file);
                    if (existing.isValid()) {
                        return Optional.of(urn);
                    }
                }
                return Optional.empty();
            }
            catch (InvalidAssetFilenameException e) {
                logger.debug("Deleted file does not have a valid file name - {}", (Object)file);
            }
        }
        return Optional.empty();
    }

    public void clearAssetFiles() {
        this.unloadedAssetLookup.clear();
        this.redirectMap.clear();
        this.redirectSourceMap.clear();
        this.resolutionMap.clear();
    }

    public List<String> getFolderNames() {
        return this.folderNames;
    }

    private static interface RegisterSourceHandler<T extends AssetData, U extends FileFormat> {
        public boolean registerSource(UnloadedAssetData<T> var1, Name var2, U var3, FileReference var4);
    }
}

