/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.format.producer;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.AssetData;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.format.AssetAlterationFileFormat;
import org.terasology.gestalt.assets.format.AssetDataFile;
import org.terasology.gestalt.assets.format.AssetFileFormat;
import org.terasology.gestalt.assets.format.FileFormat;
import org.terasology.gestalt.assets.format.producer.ModuleDependencyProvider;
import org.terasology.gestalt.module.resources.FileReference;
import org.terasology.gestalt.naming.Name;

@ThreadSafe
class UnloadedAssetData<T extends AssetData> {
    private static final Logger logger = LoggerFactory.getLogger(UnloadedAssetData.class);
    private final ModuleDependencyProvider moduleDependencies;
    private final ResourceUrn urn;
    private final List<Source<AssetFileFormat<T>>> sources = Collections.synchronizedList(Lists.newArrayList());
    private final List<Source<AssetAlterationFileFormat<T>>> supplementSources = Collections.synchronizedList(Lists.newArrayList());
    private final List<Source<AssetAlterationFileFormat<T>>> deltaSources = Collections.synchronizedList(Lists.newArrayList());

    public UnloadedAssetData(ResourceUrn urn, ModuleDependencyProvider moduleDependencies) {
        this.urn = urn;
        this.moduleDependencies = moduleDependencies;
    }

    public ResourceUrn getUrn() {
        return this.urn;
    }

    public boolean isValid() {
        return !this.sources.isEmpty();
    }

    public boolean addSource(Name providingModule, AssetFileFormat<T> format, FileReference input) {
        if (!providingModule.equals((Object)this.urn.getModuleName()) && !this.moduleDependencies.dependencyExists(providingModule, this.urn.getModuleName())) {
            logger.warn("Module '{}' provides override for non-dependency '{}' - {}", new Object[]{providingModule, this.urn.getModuleName(), this.urn});
            return false;
        }
        this.sources.add(new Source<AssetFileFormat<T>>(providingModule, format, new AssetDataFile(input)));
        return true;
    }

    public boolean removeSource(Name providingModule, AssetFileFormat<T> format, FileReference input) {
        return this.sources.remove(new Source<AssetFileFormat<T>>(providingModule, format, new AssetDataFile(input)));
    }

    public boolean addDeltaSource(Name providingModule, AssetAlterationFileFormat<T> format, FileReference input) {
        if (!providingModule.equals((Object)this.urn.getModuleName()) && !this.moduleDependencies.dependencyExists(providingModule, this.urn.getModuleName())) {
            logger.warn("Module '{}' provides delta for non-dependency '{}' - {}", new Object[]{providingModule, this.urn.getModuleName(), this.urn});
            return false;
        }
        this.deltaSources.add(new Source<AssetAlterationFileFormat<T>>(providingModule, format, new AssetDataFile(input)));
        return true;
    }

    public boolean removeDeltaSource(Name providingModule, AssetAlterationFileFormat<T> format, FileReference input) {
        return this.deltaSources.remove(new Source<AssetAlterationFileFormat<T>>(providingModule, format, new AssetDataFile(input)));
    }

    public boolean addSupplementSource(Name providingModule, AssetAlterationFileFormat<T> format, FileReference input) {
        if (!providingModule.equals((Object)this.urn.getModuleName()) && !this.moduleDependencies.dependencyExists(providingModule, this.urn.getModuleName())) {
            logger.warn("Module '{}' provides supplement for non-dependency '{}' - {}", new Object[]{providingModule, this.urn.getModuleName(), this.urn});
            return false;
        }
        this.supplementSources.add(new Source<AssetAlterationFileFormat<T>>(providingModule, format, new AssetDataFile(input)));
        return true;
    }

    public boolean removeSupplementSource(Name providingModule, AssetAlterationFileFormat<T> format, FileReference input) {
        return this.supplementSources.remove(new Source<AssetAlterationFileFormat<T>>(providingModule, format, new AssetDataFile(input)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> load() throws IOException {
        AssetSourceResolver assetDataLoader = new AssetSourceResolver();
        Object result = assetDataLoader.load();
        if (result != null) {
            Name baseModule = assetDataLoader.getProvidingModule();
            List<Source<AssetAlterationFileFormat<T>>> list = this.supplementSources;
            synchronized (list) {
                for (Source<AssetAlterationFileFormat<T>> source : this.supplementSources) {
                    if (!((Source)source).providingModule.equals((Object)baseModule)) continue;
                    ((AssetAlterationFileFormat)((Source)source).format).apply(((Source)source).input, result);
                }
            }
            list = this.deltaSources;
            synchronized (list) {
                this.deltaSources.sort(new SourceComparator(this.moduleDependencies.getModulesOrderedByDependency()));
                for (Source<AssetAlterationFileFormat<T>> source : this.deltaSources) {
                    if (!((Source)source).providingModule.equals((Object)baseModule) && this.moduleDependencies.dependencyExists(baseModule, ((Source)source).providingModule)) continue;
                    ((AssetAlterationFileFormat)((Source)source).format).apply(((Source)source).input, result);
                }
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.urn.toString();
    }

    private class AssetSourceResolver {
        private Name providingModule;
        private AssetFileFormat<T> format;
        private List<AssetDataFile> inputs = Lists.newArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AssetSourceResolver() {
            List<Name> moduleOrdering = UnloadedAssetData.this.moduleDependencies.getModulesOrderedByDependency();
            List list = UnloadedAssetData.this.sources;
            synchronized (list) {
                UnloadedAssetData.this.sources.sort(new SourceComparator(moduleOrdering));
                for (Source source : UnloadedAssetData.this.sources) {
                    if (this.providingModule == null) {
                        this.providingModule = source.providingModule;
                        this.format = (AssetFileFormat)source.format;
                        this.inputs.add(source.input);
                        continue;
                    }
                    if (this.providingModule.equals((Object)source.providingModule)) {
                        if (!this.format.equals(source.format)) continue;
                        this.inputs.add(source.input);
                        continue;
                    }
                    if (UnloadedAssetData.this.moduleDependencies.dependencyExists(source.providingModule, this.providingModule)) {
                        this.providingModule = source.providingModule;
                        this.format = (AssetFileFormat)source.format;
                        this.inputs.clear();
                        this.inputs.add(source.input);
                        continue;
                    }
                    if (UnloadedAssetData.this.moduleDependencies.dependencyExists(this.providingModule, source.providingModule)) continue;
                    logger.warn("Conflict - both module '{}' and '{}' override {}, selecting '{}'", new Object[]{this.providingModule, source.providingModule, UnloadedAssetData.this.urn, this.providingModule});
                }
            }
        }

        public Name getProvidingModule() {
            return this.providingModule;
        }

        public T load() throws IOException {
            if (this.providingModule != null) {
                return this.format.load(UnloadedAssetData.this.urn, this.inputs);
            }
            return null;
        }
    }

    private static class SourceComparator<T extends FileFormat>
    implements Comparator<Source<T>> {
        private final List<Name> moduleOrdering;

        public SourceComparator(List<Name> moduleOrdering) {
            this.moduleOrdering = moduleOrdering;
        }

        @Override
        public int compare(Source<T> o1, Source<T> o2) {
            return this.moduleOrdering.indexOf(((Source)o1).providingModule) - this.moduleOrdering.indexOf(((Source)o2).providingModule);
        }
    }

    private static class Source<U extends FileFormat> {
        private final Name providingModule;
        private final U format;
        private final AssetDataFile input;

        public Source(Name providingModule, U format, AssetDataFile input) {
            this.providingModule = providingModule;
            this.format = format;
            this.input = input;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Source) {
                Source other = (Source)obj;
                return Objects.equals(this.input, other.input);
            }
            return false;
        }

        public int hashCode() {
            return this.input.hashCode();
        }

        public String toString() {
            return this.input.toString();
        }
    }
}

