/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.management;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.terasology.gestalt.assets.Asset;
import org.terasology.gestalt.assets.AssetData;
import org.terasology.gestalt.assets.AssetType;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.management.AssetTypeManager;
import org.terasology.gestalt.assets.management.ContextManager;
import org.terasology.gestalt.module.sandbox.API;
import org.terasology.gestalt.naming.Name;

@API
@ThreadSafe
public final class AssetManager {
    private final AssetTypeManager assetTypeManager;

    public AssetManager(AssetTypeManager assetTypeManager) {
        this.assetTypeManager = assetTypeManager;
    }

    public boolean isLoaded(ResourceUrn urn, Class<? extends Asset<?>> type) {
        for (AssetType<Asset<?>, ?> assetType : this.assetTypeManager.getAssetTypes(type)) {
            if (!assetType.isLoaded(urn)) continue;
            return true;
        }
        return false;
    }

    public <T extends Asset<?>> Set<ResourceUrn> getLoadedAssetUrns(Class<T> type) {
        List<AssetType<T, ?>> assetTypes = this.assetTypeManager.getAssetTypes(type);
        switch (assetTypes.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return assetTypes.get(0).getLoadedAssetUrns();
            }
        }
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (AssetType<T, ?> assetType : assetTypes) {
            result.addAll(assetType.getLoadedAssetUrns());
        }
        return result;
    }

    public <T extends Asset<U>, U extends AssetData> Set<T> getLoadedAssets(Class<T> type) {
        List<AssetType<T, ?>> assetTypes = this.assetTypeManager.getAssetTypes(type);
        switch (assetTypes.size()) {
            case 0: {
                return Collections.emptySet();
            }
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (AssetType<T, ?> assetType : assetTypes) {
            builder.addAll(assetType.getLoadedAssets());
        }
        return builder.build();
    }

    public <T extends Asset<?>> Set<ResourceUrn> getAvailableAssets(Class<T> type) {
        List<AssetType<T, ?>> assetTypes = this.assetTypeManager.getAssetTypes(type);
        switch (assetTypes.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return assetTypes.get(0).getAvailableAssetUrns();
            }
        }
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (AssetType<T, ?> assetType : assetTypes) {
            result.addAll(assetType.getAvailableAssetUrns());
        }
        return result;
    }

    public <T extends Asset<?>> Set<ResourceUrn> resolve(String urn, Class<T> type) {
        return this.resolve(urn, type, ContextManager.getCurrentContext());
    }

    public <T extends Asset<?>> Set<ResourceUrn> resolve(String urn, Class<T> type, Name moduleContext) {
        List<AssetType<T, ?>> assetTypes = this.assetTypeManager.getAssetTypes(type);
        switch (assetTypes.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return assetTypes.get(0).resolve(urn, moduleContext);
            }
        }
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (AssetType<T, ?> assetType : assetTypes) {
            result.addAll(assetType.resolve(urn, moduleContext));
        }
        return result;
    }

    public <T extends Asset<U>, U extends AssetData> Optional<T> getAsset(String urn, Class<T> type) {
        return this.getAsset(urn, type, ContextManager.getCurrentContext());
    }

    public <T extends Asset<U>, U extends AssetData> Optional<T> getAsset(String urn, Class<T> type, Name moduleContext) {
        Set<ResourceUrn> resourceUrns = this.resolve(urn, type, moduleContext);
        if (resourceUrns.size() == 1) {
            return this.getAsset(resourceUrns.iterator().next(), type);
        }
        return Optional.empty();
    }

    public <T extends Asset<U>, U extends AssetData> Optional<T> getAsset(ResourceUrn urn, Class<T> type) {
        List<AssetType<T, ?>> assetTypes = this.assetTypeManager.getAssetTypes(type);
        switch (assetTypes.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                Optional<T> result = assetTypes.get(0).getAsset(urn);
                if (!result.isPresent()) break;
                return Optional.of(result.get());
            }
            default: {
                for (AssetType<T, ?> assetType : assetTypes) {
                    Optional<T> result = assetType.getAsset(urn);
                    if (!result.isPresent()) continue;
                    return Optional.of(result.get());
                }
            }
        }
        return Optional.empty();
    }

    public <T extends Asset<U>, U extends AssetData> T loadAsset(ResourceUrn urn, U data, Class<T> type) {
        Optional assetType = this.assetTypeManager.getAssetType(type);
        if (assetType.isPresent()) {
            return assetType.get().loadAsset(urn, data);
        }
        throw new IllegalStateException(type + " is not a supported type of asset");
    }
}

