/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.management;

import com.google.common.collect.Queues;
import java.util.Deque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.management.Context;
import org.terasology.gestalt.naming.Name;

public final class ContextManager {
    private static final Logger logger = LoggerFactory.getLogger(ContextManager.class);
    private static final ThreadLocal<Deque<Name>> CONTEXT_STACK = ThreadLocal.withInitial(Queues::newArrayDeque);

    private ContextManager() {
    }

    public static Name getCurrentContext() {
        Name context = CONTEXT_STACK.get().peek();
        return context != null ? context : Name.EMPTY;
    }

    public static Context beginContext(final Name moduleId) {
        CONTEXT_STACK.get().push(moduleId);
        return new Context(){

            @Override
            public Name getContext() {
                return moduleId;
            }

            @Override
            public void close() {
                Deque stack = (Deque)CONTEXT_STACK.get();
                if (!moduleId.equals(stack.pop())) {
                    logger.error("Module context ended out of sequence");
                }
                if (stack.isEmpty()) {
                    CONTEXT_STACK.remove();
                }
            }
        };
    }
}

