/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.management;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.jcip.annotations.ThreadSafe;
import org.reflections.ReflectionUtils;
import org.terasology.gestalt.assets.Asset;
import org.terasology.gestalt.assets.AssetData;
import org.terasology.gestalt.assets.AssetFactory;
import org.terasology.gestalt.assets.AssetType;
import org.terasology.gestalt.assets.management.AssetTypeManager;

@ThreadSafe
public final class MapAssetTypeManager
implements AssetTypeManager {
    private final Map<Class<? extends Asset>, AssetType<?, ?>> assetTypes = new MapMaker().concurrencyLevel(1).makeMap();
    private final ListMultimap<Class<? extends Asset>, Class<? extends Asset>> subtypes = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

    @Override
    public <T extends Asset<U>, U extends AssetData> Optional<AssetType<T, U>> getAssetType(Class<T> type) {
        return Optional.ofNullable(this.assetTypes.get(type));
    }

    @Override
    public <T extends Asset<?>> List<AssetType<? extends T, ?>> getAssetTypes(Class<T> type) {
        ArrayList result = Lists.newArrayList();
        for (Class subtype : ImmutableList.copyOf((Collection)this.subtypes.get(type))) {
            result.add(this.assetTypes.get(subtype));
        }
        return result;
    }

    @Override
    public Collection<AssetType<?, ?>> getAssetTypes() {
        return Collections.unmodifiableCollection(this.assetTypes.values());
    }

    @Override
    public void disposedUnusedAssets() {
        this.assetTypes.values().forEach(type -> type.processDisposal());
    }

    public synchronized <T extends Asset<U>, U extends AssetData> AssetType<T, U> createAssetType(Class<T> type, AssetFactory<T, U> factory) {
        Preconditions.checkState((this.assetTypes.get(type) == null ? 1 : 0) != 0, (Object)("Asset type already created - " + type.getSimpleName()));
        Preconditions.checkNotNull(factory);
        Preconditions.checkNotNull(type);
        AssetType<T, U> assetType = new AssetType<T, U>(type, factory);
        this.addAssetType(assetType);
        return assetType;
    }

    public synchronized void addAssetType(AssetType<?, ?> assetType) {
        Preconditions.checkNotNull(assetType);
        Preconditions.checkState((this.assetTypes.get(assetType.getAssetClass()) == null ? 1 : 0) != 0, (Object)("Asset type already registered for - " + assetType.getAssetClass().getSimpleName()));
        this.assetTypes.put(assetType.getAssetClass(), assetType);
        for (Class parentType : ReflectionUtils.getAllSuperTypes(assetType.getAssetClass(), (Predicate[])new Predicate[]{input -> Asset.class.isAssignableFrom((Class<?>)input) && input != Asset.class})) {
            this.subtypes.put((Object)parentType, assetType.getAssetClass());
            this.subtypes.get((Object)parentType).sort(Comparator.comparing(Class::getSimpleName));
        }
    }

    public synchronized <T extends Asset<?>> AssetType<?, ?> removeAssetType(Class<T> type) {
        AssetType<?, ?> assetType = this.assetTypes.remove(type);
        if (assetType != null) {
            assetType.close();
            for (Class parentType : ReflectionUtils.getAllSuperTypes(type, (Predicate[])new Predicate[]{input -> Asset.class.isAssignableFrom((Class<?>)input) && input != Asset.class})) {
                this.subtypes.remove((Object)parentType, type);
            }
        }
        return assetType;
    }

    public synchronized void clear() {
        for (AssetType<?, ?> assetType : this.assetTypes.values()) {
            assetType.close();
        }
        this.assetTypes.clear();
        this.subtypes.clear();
    }
}

