/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.module;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.format.producer.AssetFileDataProducer;
import org.terasology.gestalt.module.Module;
import org.terasology.gestalt.module.ModuleEnvironment;
import org.terasology.gestalt.module.resources.FileReference;
import org.terasology.gestalt.naming.Name;

public class ModuleAssetScanner {
    public static final String ASSET_FOLDER = "assets";
    public static final String OVERRIDE_FOLDER = "overrides";
    public static final String DELTA_FOLDER = "deltas";
    private static final Logger logger = LoggerFactory.getLogger(ModuleAssetScanner.class);
    private Cache<Module, CacheEntry> assetPathCache;
    private Cache<Module, CacheEntry> overridePathCache;
    private Cache<Module, CacheEntry> deltaPathCache;

    public ModuleAssetScanner() {
        this(128);
    }

    public ModuleAssetScanner(int cacheSize) {
        this.assetPathCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).removalListener(notification -> logger.debug("Cleared cache of asset paths for {} - {}", notification.getKey(), (Object)notification.getCause())).build();
        this.overridePathCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).removalListener(notification -> logger.debug("Cleared cache of override paths for {} - {}", notification.getKey(), (Object)notification.getCause())).build();
        this.deltaPathCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).removalListener(notification -> logger.debug("Cleared cache of delta paths for {} - {}", notification.getKey(), (Object)notification.getCause())).build();
    }

    public void scan(ModuleEnvironment environment, AssetFileDataProducer<?> producer) {
        this.scanForAssets(environment, producer);
        this.scanForOverrides(environment, producer);
        this.scanForDeltas(environment, producer);
    }

    public void clearCache() {
        this.assetPathCache.invalidateAll();
        this.overridePathCache.invalidateAll();
        this.deltaPathCache.invalidateAll();
    }

    private void scanForAssets(ModuleEnvironment environment, AssetFileDataProducer<?> producer) {
        for (Module module : environment.getModulesOrderedByDependencies()) {
            try {
                CacheEntry cacheEntry = (CacheEntry)this.assetPathCache.get((Object)module, () -> {
                    CacheEntry newCache = new CacheEntry();
                    this.scanForPathCache(module, newCache, ASSET_FOLDER);
                    return newCache;
                });
                for (String folderName : producer.getFolderNames()) {
                    for (FileReference file : cacheEntry.getPathsByRootFolder().get((Object)new Name(folderName))) {
                        producer.assetFileAdded(file, module.getId(), module.getId());
                    }
                }
            }
            catch (ExecutionException e) {
                logger.error("Failed to scan asset path", (Throwable)e);
            }
        }
    }

    private void scanForOverrides(ModuleEnvironment environment, AssetFileDataProducer<?> producer) {
        for (Module module : environment.getModulesOrderedByDependencies()) {
            try {
                CacheEntry cacheEntry = (CacheEntry)this.overridePathCache.get((Object)module, () -> {
                    CacheEntry newCache = new CacheEntry();
                    Set subpaths = module.getResources().getSubpaths(new String[]{OVERRIDE_FOLDER});
                    for (String overrideModule : subpaths) {
                        this.scanForPathCache(module, newCache, OVERRIDE_FOLDER, overrideModule);
                    }
                    return newCache;
                });
                for (String folderName : producer.getFolderNames()) {
                    for (FileReference file : cacheEntry.getPathsByRootFolder().get((Object)new Name(folderName))) {
                        producer.assetFileAdded(file, new Name((String)file.getPath().get(1)), module.getId());
                    }
                }
            }
            catch (ExecutionException e) {
                logger.error("Failed to scan asset path", (Throwable)e);
            }
        }
    }

    private void scanForDeltas(ModuleEnvironment environment, AssetFileDataProducer<?> producer) {
        for (Module module : environment.getModulesOrderedByDependencies()) {
            try {
                CacheEntry cacheEntry = (CacheEntry)this.deltaPathCache.get((Object)module, () -> {
                    CacheEntry newCache = new CacheEntry();
                    Set subpaths = module.getResources().getSubpaths(new String[]{DELTA_FOLDER});
                    for (String moduleDelta : subpaths) {
                        this.scanForPathCache(module, newCache, DELTA_FOLDER, moduleDelta);
                    }
                    return newCache;
                });
                for (String folderName : producer.getFolderNames()) {
                    for (FileReference file : cacheEntry.getPathsByRootFolder().get((Object)new Name(folderName))) {
                        producer.deltaFileAdded(file, new Name((String)file.getPath().get(1)), module.getId());
                    }
                }
            }
            catch (ExecutionException e) {
                logger.error("Failed to scan delta path", (Throwable)e);
            }
        }
    }

    private void scanForPathCache(Module originModule, CacheEntry cache, String ... rootPath) {
        for (String typeFolder : originModule.getResources().getSubpaths(rootPath)) {
            Name type = new Name(typeFolder);
            for (FileReference fileReference : originModule.getResources().getFilesInPath(true, this.concat(rootPath, typeFolder))) {
                cache.getPathsByRootFolder().put((Object)type, (Object)fileReference);
            }
        }
    }

    private String[] concat(String[] array, String item) {
        String[] result = Arrays.copyOf(array, array.length + 1);
        result[array.length] = item;
        return result;
    }

    private static class CacheEntry {
        private ListMultimap<Name, FileReference> pathsByFolder = ArrayListMultimap.create();

        private CacheEntry() {
        }

        ListMultimap<Name, FileReference> getPathsByRootFolder() {
            return this.pathsByFolder;
        }
    }
}

