/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.module;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.Asset;
import org.terasology.gestalt.assets.AssetData;
import org.terasology.gestalt.assets.AssetDataProducer;
import org.terasology.gestalt.assets.AssetFactory;
import org.terasology.gestalt.assets.AssetType;
import org.terasology.gestalt.assets.format.AssetAlterationFileFormat;
import org.terasology.gestalt.assets.format.AssetFileFormat;
import org.terasology.gestalt.assets.format.producer.AssetFileDataProducer;
import org.terasology.gestalt.assets.format.producer.ModuleDependencyProvider;
import org.terasology.gestalt.assets.management.AssetManager;
import org.terasology.gestalt.assets.management.MapAssetTypeManager;
import org.terasology.gestalt.assets.module.ModuleAssetScanner;
import org.terasology.gestalt.assets.module.ModuleAwareAssetTypeManager;
import org.terasology.gestalt.assets.module.ModuleDependencyResolutionStrategy;
import org.terasology.gestalt.assets.module.ModuleEnvironmentDependencyProvider;
import org.terasology.gestalt.assets.module.annotations.RegisterAssetDataProducer;
import org.terasology.gestalt.assets.module.annotations.RegisterAssetDeltaFileFormat;
import org.terasology.gestalt.assets.module.annotations.RegisterAssetFileFormat;
import org.terasology.gestalt.assets.module.annotations.RegisterAssetSupplementalFileFormat;
import org.terasology.gestalt.assets.module.annotations.RegisterAssetType;
import org.terasology.gestalt.module.ModuleEnvironment;
import org.terasology.gestalt.util.reflection.ClassFactory;
import org.terasology.gestalt.util.reflection.GenericsUtil;
import org.terasology.gestalt.util.reflection.ParameterProvider;
import org.terasology.gestalt.util.reflection.SimpleClassFactory;

public class ModuleAwareAssetTypeManagerImpl
implements ModuleAwareAssetTypeManager {
    private static final Logger logger = LoggerFactory.getLogger(ModuleAwareAssetTypeManagerImpl.class);
    private final MapAssetTypeManager assetTypeManager = new MapAssetTypeManager();
    private final AssetManager assetManager = new AssetManager(this);
    private final ModuleEnvironmentDependencyProvider dependencyProvider = new ModuleEnvironmentDependencyProvider();
    private final ClassFactory classFactory;
    private final ModuleAssetScanner assetScanner = new ModuleAssetScanner();
    private final Map<AssetType<?, ?>, AssetTypeInfo> assetTypeInfo = Maps.newHashMap();

    public ModuleAwareAssetTypeManagerImpl() {
        this.classFactory = new SimpleClassFactory(new ParameterProvider(){

            public <T> Optional<T> get(Class<T> type) {
                if (type.equals(AssetManager.class)) {
                    return Optional.of(ModuleAwareAssetTypeManagerImpl.this.assetManager);
                }
                return Optional.empty();
            }
        });
    }

    @Override
    public void clearAvailableAssetCache() {
        this.assetScanner.clearCache();
    }

    public ModuleAwareAssetTypeManagerImpl(ClassFactory classFactory) {
        this.classFactory = classFactory;
    }

    @Override
    public synchronized void close() {
        this.unloadEnvironment();
        this.assetTypeManager.clear();
        this.assetTypeInfo.clear();
        this.assetScanner.clearCache();
    }

    @Override
    public <T extends Asset<U>, U extends AssetData> Optional<AssetType<T, U>> getAssetType(Class<T> type) {
        return this.assetTypeManager.getAssetType(type);
    }

    @Override
    public <T extends Asset<?>> List<AssetType<? extends T, ?>> getAssetTypes(Class<T> type) {
        return this.assetTypeManager.getAssetTypes(type);
    }

    @Override
    public Collection<AssetType<?, ?>> getAssetTypes() {
        return this.assetTypeManager.getAssetTypes();
    }

    @Override
    public void disposedUnusedAssets() {
        this.assetTypeManager.disposedUnusedAssets();
    }

    @Override
    public synchronized <T extends Asset<U>, U extends AssetData> AssetType<T, U> createAssetType(Class<T> type, AssetFactory<T, U> factory, String ... subfolderNames) {
        return this.createAssetType(type, factory, Arrays.asList(subfolderNames));
    }

    @Override
    public synchronized <T extends Asset<U>, U extends AssetData> AssetType<T, U> createAssetType(Class<T> type, AssetFactory<T, U> factory, Collection<String> subfolderNames) {
        AssetType<T, U> assetType = new AssetType<T, U>(type, factory);
        this.addAssetType(assetType, subfolderNames);
        return assetType;
    }

    @Override
    public synchronized <T extends Asset<U>, U extends AssetData> AssetType<T, U> addAssetType(AssetType<T, U> assetType, String ... subfolderNames) {
        return this.addAssetType(assetType, Arrays.asList(subfolderNames));
    }

    @Override
    public synchronized <T extends Asset<U>, U extends AssetData> AssetType<T, U> addAssetType(AssetType<T, U> assetType, Collection<String> subfolderNames) {
        return this.addAssetType(assetType, false, subfolderNames);
    }

    private <T extends Asset<U>, U extends AssetData> AssetType<T, U> addAssetType(AssetType<T, U> assetType, boolean extension, Collection<String> subfolderNames) {
        this.assetTypeManager.addAssetType(assetType);
        assetType.setResolutionStrategy(new ModuleDependencyResolutionStrategy(this.dependencyProvider));
        AssetTypeInfo info = new AssetTypeInfo(assetType, extension);
        AssetFileDataProducer producer = new AssetFileDataProducer((ModuleDependencyProvider)this.dependencyProvider, subfolderNames);
        info.setFileProducer(producer);
        assetType.addProducer(producer);
        this.assetTypeInfo.put(assetType, info);
        return assetType;
    }

    @Override
    public <T extends Asset<U>, U extends AssetData> AssetFileDataProducer<U> getAssetFileDataProducer(AssetType<T, U> assetType) {
        Preconditions.checkArgument((boolean)this.assetTypeInfo.containsKey(assetType));
        return this.assetTypeInfo.get(assetType).getFileProducer();
    }

    @Override
    public synchronized <T extends Asset<U>, U extends AssetData> void removeAssetType(Class<T> type) {
        AssetType<?, ?> assetType = this.assetTypeManager.removeAssetType(type);
        this.assetTypeInfo.remove(assetType);
        assetType.close();
    }

    @Override
    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    @Override
    public synchronized void switchEnvironment(ModuleEnvironment newEnvironment) {
        Preconditions.checkNotNull((Object)newEnvironment);
        this.unloadEnvironment();
        this.addExtensionAssetTypes(newEnvironment);
        this.addExtensionFormats(newEnvironment);
        this.addExtensionProducers(newEnvironment);
        this.registerAssetFiles(newEnvironment);
    }

    @Override
    public synchronized void unloadEnvironment() {
        if (this.dependencyProvider.getModuleEnvironment() != null) {
            this.removeExtensionAssetTypes();
            this.removeExtensionFormats();
            this.removeExtensionProducers();
            this.dependencyProvider.setModuleEnvironment(null);
            this.clearAssetFiles();
        }
    }

    @Override
    public void reloadAssets() {
        for (AssetType<?, ?> assetType : this.assetTypeManager.getAssetTypes()) {
            assetType.getLoadedAssetUrns().forEach(assetType::reload);
        }
    }

    private void registerAssetFiles(ModuleEnvironment newEnvironment) {
        this.dependencyProvider.setModuleEnvironment(newEnvironment);
        for (AssetTypeInfo typeInfo : this.assetTypeInfo.values()) {
            this.assetScanner.scan(newEnvironment, typeInfo.getFileProducer());
        }
    }

    private void clearAssetFiles() {
        for (AssetTypeInfo info : this.assetTypeInfo.values()) {
            info.getFileProducer().clearAssetFiles();
        }
    }

    private void removeExtensionProducers() {
        for (AssetTypeInfo info : this.assetTypeInfo.values()) {
            info.removeAllAssetDataProducers();
        }
    }

    private void removeExtensionFormats() {
        for (AssetTypeInfo info : this.assetTypeInfo.values()) {
            info.removeAllExtensionFormats();
        }
    }

    private void removeExtensionAssetTypes() {
        for (AssetType assetType : ImmutableList.copyOf(this.assetTypeManager.getAssetTypes())) {
            AssetTypeInfo info = this.assetTypeInfo.get(assetType);
            if (info == null || !info.isExtension()) continue;
            this.assetTypeManager.removeAssetType(assetType.getAssetClass());
            this.assetTypeInfo.remove(assetType);
        }
    }

    private void addExtensionAssetTypes(ModuleEnvironment environment) {
        for (Class type : environment.getTypesAnnotatedWith(RegisterAssetType.class, Asset.class::isAssignableFrom)) {
            Class assetClass = type;
            Optional assetDataType = GenericsUtil.getTypeParameterBindingForInheritedClass((Type)assetClass, Asset.class, (int)0);
            if (!assetDataType.isPresent()) {
                logger.error("Could not register AssetType for '{}' - asset data type must be bound in inheritance tree", (Object)assetClass);
                continue;
            }
            RegisterAssetType registrationInfo = assetClass.getAnnotation(RegisterAssetType.class);
            Optional factory = this.classFactory.instantiateClass(registrationInfo.factoryClass());
            if (!factory.isPresent()) continue;
            if (!this.assetTypeManager.getAssetType(assetClass).isPresent()) {
                this.createExtensionAssetType(assetClass, (AssetFactory)factory.get(), Arrays.asList(registrationInfo.folderName()));
                continue;
            }
            logger.error("Asset Type already registered for type '{}' - discarding additional registration", (Object)assetClass);
        }
    }

    private <T extends Asset<U>, U extends AssetData> void createExtensionAssetType(Class<T> type, AssetFactory<T, U> factory, Collection<String> subfolderNames) {
        AssetType<T, U> assetType = new AssetType<T, U>(type, factory);
        this.addAssetType(assetType, true, subfolderNames);
    }

    private void addExtensionFormats(ModuleEnvironment newEnvironment) {
        this.scanAndRegisterExtension(newEnvironment, AssetFileFormat.class, RegisterAssetFileFormat.class, AssetTypeInfo::addExtensionFileFormat);
        this.scanAndRegisterExtension(newEnvironment, AssetAlterationFileFormat.class, RegisterAssetSupplementalFileFormat.class, AssetTypeInfo::addExtensionSupplementFormat);
        this.scanAndRegisterExtension(newEnvironment, AssetAlterationFileFormat.class, RegisterAssetDeltaFileFormat.class, AssetTypeInfo::addExtensionDeltaFormat);
    }

    private void addExtensionProducers(ModuleEnvironment environment) {
        this.scanAndRegisterExtension(environment, AssetDataProducer.class, RegisterAssetDataProducer.class, AssetTypeInfo::addExtensionProducer);
    }

    private <T> void scanAndRegisterExtension(ModuleEnvironment environment, Class<T> baseType, Class<? extends Annotation> annotationType, BiConsumer<AssetTypeInfo, T> register) {
        ListMultimap<Class<AssetData>, T> extensions = this.scanForTypes(environment, baseType, annotationType);
        for (Class assetDataClass : extensions.keySet()) {
            for (Object extension : extensions.get((Object)assetDataClass)) {
                this.assetTypeInfo.entrySet().stream().filter(t -> ((AssetType)t.getKey()).getAssetDataClass().equals(assetDataClass)).forEach(t -> register.accept((AssetTypeInfo)t.getValue(), (Object)extension));
            }
        }
    }

    private <T> ListMultimap<Class<? extends AssetData>, T> scanForTypes(ModuleEnvironment environment, Class<T> baseType, Class<? extends Annotation> annotationType) {
        ArrayListMultimap discoveredTypes = ArrayListMultimap.create();
        for (T format : this.findAndInstantiateClasses(environment, baseType, annotationType)) {
            Optional assetDataType = GenericsUtil.getTypeParameterBindingForInheritedClass(format.getClass(), baseType, (int)0);
            if (!assetDataType.isPresent()) {
                logger.error("Could not register '{}' - asset data type must be bound in inheritance tree", format.getClass());
                continue;
            }
            Class assetDataClass = GenericsUtil.getClassOfType((Type)((Type)assetDataType.get()));
            discoveredTypes.put((Object)assetDataClass, format);
        }
        return discoveredTypes;
    }

    private <T> List<T> findAndInstantiateClasses(ModuleEnvironment environment, Class<T> baseType, Class<? extends Annotation> annotation) {
        ArrayList result = Lists.newArrayList();
        for (Class discoveredType : environment.getTypesAnnotatedWith(annotation, input -> baseType.isAssignableFrom((Class<?>)input) && !Modifier.isAbstract(input.getModifiers()))) {
            Optional instance = this.classFactory.instantiateClass(discoveredType);
            instance.ifPresent(result::add);
        }
        return result;
    }

    private static class AssetTypeInfo {
        private boolean extension;
        private AssetType<?, ?> assetType;
        private AssetFileDataProducer fileProducer;
        private List<AssetFileFormat> extensionFileFormats = Lists.newArrayList();
        private List<AssetAlterationFileFormat> extensionSupplementFormats = Lists.newArrayList();
        private List<AssetAlterationFileFormat> extensionDeltaFormats = Lists.newArrayList();
        private List<AssetDataProducer> extensionProducers = Lists.newArrayList();

        AssetTypeInfo(AssetType assetType, boolean extension) {
            this.assetType = assetType;
            this.extension = extension;
        }

        public AssetType getAssetType() {
            return this.assetType;
        }

        boolean isExtension() {
            return this.extension;
        }

        AssetFileDataProducer<?> getFileProducer() {
            return this.fileProducer;
        }

        void setFileProducer(AssetFileDataProducer fileProducer) {
            this.fileProducer = fileProducer;
        }

        void addExtensionProducer(AssetDataProducer producer) {
            this.extensionProducers.add(producer);
            this.assetType.addProducer(producer);
        }

        void addExtensionFileFormat(AssetFileFormat assetFileFormat) {
            this.extensionFileFormats.add(assetFileFormat);
            this.fileProducer.addAssetFormat(assetFileFormat);
        }

        void addExtensionSupplementFormat(AssetAlterationFileFormat supplementFormat) {
            this.extensionSupplementFormats.add(supplementFormat);
            this.fileProducer.addSupplementFormat(supplementFormat);
        }

        void addExtensionDeltaFormat(AssetAlterationFileFormat deltaFormat) {
            this.extensionDeltaFormats.add(deltaFormat);
            this.fileProducer.addDeltaFormat(deltaFormat);
        }

        void removeAllExtensionFormats() {
            this.extensionFileFormats.forEach(this.fileProducer::removeAssetFormat);
            this.extensionFileFormats.clear();
            this.extensionSupplementFormats.forEach(this.fileProducer::removeSupplementFormat);
            this.extensionSupplementFormats.clear();
            this.extensionDeltaFormats.forEach(this.fileProducer::removeDeltaFormat);
            this.extensionDeltaFormats.clear();
        }

        void removeAllAssetDataProducers() {
            this.extensionProducers.forEach(this.assetType::removeProducer);
            this.extensionProducers.clear();
        }
    }
}

