/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.module;

import android.support.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import org.terasology.gestalt.assets.format.producer.ModuleDependencyProvider;
import org.terasology.gestalt.module.ModuleEnvironment;
import org.terasology.gestalt.naming.Name;

public class ModuleEnvironmentDependencyProvider
implements ModuleDependencyProvider {
    private volatile ModuleEnvironment moduleEnvironment;

    public ModuleEnvironmentDependencyProvider() {
    }

    public ModuleEnvironmentDependencyProvider(@Nullable ModuleEnvironment moduleEnvironment) {
        this.moduleEnvironment = moduleEnvironment;
    }

    public ModuleEnvironment getModuleEnvironment() {
        return this.moduleEnvironment;
    }

    public void setModuleEnvironment(@Nullable ModuleEnvironment moduleEnvironment) {
        this.moduleEnvironment = moduleEnvironment;
    }

    @Override
    public boolean dependencyExists(Name fromModule, Name onModule) {
        ModuleEnvironment currentEnvironment = this.moduleEnvironment;
        return currentEnvironment != null && currentEnvironment.getDependencyNamesOf(fromModule).contains(onModule);
    }

    @Override
    public List<Name> getModulesOrderedByDependency() {
        ModuleEnvironment currentEnvironment = this.moduleEnvironment;
        if (currentEnvironment != null) {
            return currentEnvironment.getModuleIdsOrderedByDependencies();
        }
        return Collections.emptyList();
    }
}

