/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.module.autoreload;

import android.support.annotation.RequiresApi;
import com.google.common.base.Preconditions;
import com.google.common.collect.SetMultimap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.AssetType;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.format.producer.AssetFileDataProducer;
import org.terasology.gestalt.assets.module.autoreload.ModuleEnvironmentWatcher;
import org.terasology.gestalt.module.ModuleEnvironment;

@RequiresApi(value=26)
public class AssetReloadOnChangeHandler
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AssetReloadOnChangeHandler.class);
    private final ModuleEnvironmentWatcher watcher;

    public AssetReloadOnChangeHandler(ModuleEnvironment environment) throws IOException {
        this.watcher = new ModuleEnvironmentWatcher(environment);
    }

    public void addAssetType(AssetType<?, ?> assetType, AssetFileDataProducer<?> producer) {
        for (String folder : producer.getFolderNames()) {
            this.watcher.register(folder, producer, assetType);
        }
    }

    public void removeAssetType(AssetType<?, ?> assetType) {
        this.watcher.unregister(assetType);
    }

    public void poll() {
        Preconditions.checkState((!this.watcher.isClosed() ? 1 : 0) != 0, (Object)"AutoReloadOnChangeManager has been closed");
        SetMultimap<AssetType<?, ?>, ResourceUrn> changes = this.watcher.checkForChanges();
        for (Map.Entry entry : changes.entries()) {
            if (!((AssetType)entry.getKey()).isLoaded((ResourceUrn)entry.getValue())) continue;
            AssetType assetType = (AssetType)entry.getKey();
            ResourceUrn changedUrn = (ResourceUrn)entry.getValue();
            logger.info("Reloading changed asset '{}'", (Object)changedUrn);
            assetType.reload(changedUrn);
        }
    }

    @Override
    public void close() throws IOException {
        this.watcher.shutdown();
    }
}

