/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.module.autoreload;

import android.support.annotation.RequiresApi;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.Asset;
import org.terasology.gestalt.assets.AssetData;
import org.terasology.gestalt.assets.AssetFactory;
import org.terasology.gestalt.assets.AssetType;
import org.terasology.gestalt.assets.format.producer.AssetFileDataProducer;
import org.terasology.gestalt.assets.management.AssetManager;
import org.terasology.gestalt.assets.module.ModuleAwareAssetTypeManager;
import org.terasology.gestalt.assets.module.ModuleAwareAssetTypeManagerImpl;
import org.terasology.gestalt.assets.module.autoreload.AssetReloadOnChangeHandler;
import org.terasology.gestalt.module.ModuleEnvironment;
import org.terasology.gestalt.util.reflection.ClassFactory;

@RequiresApi(value=26)
public class AutoReloadAssetTypeManager
implements ModuleAwareAssetTypeManager {
    private static final Logger logger = LoggerFactory.getLogger(AutoReloadAssetTypeManager.class);
    private ModuleAwareAssetTypeManager assetTypeManager;
    private AssetReloadOnChangeHandler reloadOnChangeHandler;

    public AutoReloadAssetTypeManager() {
        this.assetTypeManager = new ModuleAwareAssetTypeManagerImpl();
    }

    public AutoReloadAssetTypeManager(ClassFactory classFactory) {
        this.assetTypeManager = new ModuleAwareAssetTypeManagerImpl(classFactory);
    }

    public AutoReloadAssetTypeManager(ModuleAwareAssetTypeManager assetTypeManager) {
        this.assetTypeManager = assetTypeManager;
    }

    public synchronized void reloadChangedAssets() {
        if (this.reloadOnChangeHandler != null) {
            this.reloadOnChangeHandler.poll();
        }
    }

    private <U extends AssetData, T extends Asset<U>> void registerAssetType(AssetType<T, U> assetType) {
        if (this.reloadOnChangeHandler != null) {
            this.reloadOnChangeHandler.addAssetType(assetType, this.assetTypeManager.getAssetFileDataProducer(assetType));
        }
    }

    private void openReloadOnChangeHandler(ModuleEnvironment newEnvironment) {
        try {
            this.reloadOnChangeHandler = new AssetReloadOnChangeHandler(newEnvironment);
            for (AssetType<?, ?> assetType : this.getAssetTypes()) {
                this.reloadOnChangeHandler.addAssetType(assetType, this.getAssetFileDataProducer(assetType));
            }
        }
        catch (IOException e) {
            logger.error("Failed to instantiate asset reload on change handler", (Throwable)e);
        }
    }

    private void closeReloadOnChangeHandler() {
        if (this.reloadOnChangeHandler != null) {
            try {
                this.reloadOnChangeHandler.close();
            }
            catch (IOException e) {
                logger.error("Failed to close asset reload on change handler", (Throwable)e);
            }
        }
    }

    @Override
    public <T extends Asset<U>, U extends AssetData> AssetType<T, U> createAssetType(Class<T> type, AssetFactory<T, U> factory, String ... subfolderNames) {
        AssetType<T, U> assetType = this.assetTypeManager.createAssetType(type, factory, subfolderNames);
        this.registerAssetType(assetType);
        return assetType;
    }

    @Override
    public <T extends Asset<U>, U extends AssetData> AssetType<T, U> createAssetType(Class<T> type, AssetFactory<T, U> factory, Collection<String> subfolderNames) {
        AssetType<T, U> assetType = this.assetTypeManager.createAssetType(type, factory, subfolderNames);
        this.registerAssetType(assetType);
        return assetType;
    }

    @Override
    public <T extends Asset<U>, U extends AssetData> AssetType<T, U> addAssetType(AssetType<T, U> assetType, String ... subfolderNames) {
        this.assetTypeManager.addAssetType(assetType, subfolderNames);
        this.registerAssetType(assetType);
        return assetType;
    }

    @Override
    public <T extends Asset<U>, U extends AssetData> AssetType<T, U> addAssetType(AssetType<T, U> assetType, Collection<String> subfolderNames) {
        this.assetTypeManager.addAssetType(assetType, subfolderNames);
        this.registerAssetType(assetType);
        return assetType;
    }

    @Override
    public <T extends Asset<U>, U extends AssetData> AssetFileDataProducer<U> getAssetFileDataProducer(AssetType<T, U> assetType) {
        return this.assetTypeManager.getAssetFileDataProducer(assetType);
    }

    @Override
    public <T extends Asset<U>, U extends AssetData> void removeAssetType(Class<T> type) {
        this.assetTypeManager.getAssetType(type).ifPresent(assetType -> {
            this.assetTypeManager.removeAssetType(type);
            if (this.reloadOnChangeHandler != null) {
                this.reloadOnChangeHandler.removeAssetType((AssetType<?, ?>)assetType);
            }
        });
    }

    @Override
    public AssetManager getAssetManager() {
        return this.assetTypeManager.getAssetManager();
    }

    @Override
    public void switchEnvironment(ModuleEnvironment newEnvironment) {
        this.closeReloadOnChangeHandler();
        this.assetTypeManager.clearAvailableAssetCache();
        this.assetTypeManager.switchEnvironment(newEnvironment);
        this.openReloadOnChangeHandler(newEnvironment);
    }

    @Override
    public void unloadEnvironment() {
        this.closeReloadOnChangeHandler();
        this.assetTypeManager.unloadEnvironment();
    }

    @Override
    public void reloadAssets() {
        this.assetTypeManager.reloadAssets();
    }

    @Override
    public void clearAvailableAssetCache() {
        this.assetTypeManager.clearAvailableAssetCache();
    }

    @Override
    public void close() throws IOException {
        this.closeReloadOnChangeHandler();
        this.assetTypeManager.close();
    }

    @Override
    public <T extends Asset<U>, U extends AssetData> Optional<AssetType<T, U>> getAssetType(Class<T> type) {
        return this.assetTypeManager.getAssetType(type);
    }

    @Override
    public <T extends Asset<?>> List<AssetType<? extends T, ?>> getAssetTypes(Class<T> type) {
        return this.assetTypeManager.getAssetTypes(type);
    }

    @Override
    public Collection<AssetType<?, ?>> getAssetTypes() {
        return this.assetTypeManager.getAssetTypes();
    }

    @Override
    public void disposedUnusedAssets() {
        this.assetTypeManager.disposedUnusedAssets();
    }
}

