/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.assets.module.autoreload;

import android.support.annotation.RequiresApi;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Queues;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.AssetType;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.format.producer.FileChangeSubscriber;
import org.terasology.gestalt.module.Module;
import org.terasology.gestalt.module.ModuleEnvironment;
import org.terasology.gestalt.module.resources.DirectoryFileSource;
import org.terasology.gestalt.module.resources.FileReference;
import org.terasology.gestalt.naming.Name;

@RequiresApi(value=26)
class ModuleEnvironmentWatcher {
    private static final Logger logger = LoggerFactory.getLogger(ModuleEnvironmentWatcher.class);
    private final WatchService service;
    private final Map<WatchKey, PathWatcher> pathWatchers = new MapMaker().concurrencyLevel(1).makeMap();
    private final Map<Path, WatchKey> watchKeys = new MapMaker().concurrencyLevel(1).makeMap();
    private final ListMultimap<String, SubscriberInfo> subscribers = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final BlockingDeque<DelayedEvent> unreadyEvents = Queues.newLinkedBlockingDeque();
    private boolean closed;

    ModuleEnvironmentWatcher(ModuleEnvironment environment) throws IOException {
        this(environment, FileSystems.getDefault());
    }

    ModuleEnvironmentWatcher(ModuleEnvironment environment, FileSystem fileSystem) throws IOException {
        this.service = fileSystem.newWatchService();
        for (Module module : environment.getModulesOrderedByDependencies()) {
            for (Path path : module.getResources().getRootPaths()) {
                PathWatcher watcher = new PathWatcher(path, path, this.service, new RootPathWatcher(module.getId()));
                watcher.onRegistered();
            }
        }
    }

    synchronized void register(String folderName, FileChangeSubscriber subscriber, AssetType<?, ?> assetType) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot register folder into closed ModuleWatcher");
        this.subscribers.put((Object)folderName, (Object)new SubscriberInfo(assetType, subscriber));
    }

    synchronized void unregister(AssetType<?, ?> assetType) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"ModuleWatcher is closed");
        this.subscribers.values().removeIf(v -> v.type.equals(assetType));
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    synchronized void shutdown() throws IOException {
        if (!this.closed) {
            this.pathWatchers.clear();
            this.watchKeys.clear();
            this.service.close();
            this.closed = true;
        }
    }

    synchronized SetMultimap<AssetType<?, ?>, ResourceUrn> checkForChanges() {
        if (this.closed) {
            return LinkedHashMultimap.create();
        }
        LinkedHashMultimap changed = LinkedHashMultimap.create();
        ArrayList events = Lists.newArrayList();
        this.unreadyEvents.drainTo(events);
        for (DelayedEvent event : events) {
            changed.putAll(event.replay());
        }
        WatchKey key = this.service.poll();
        while (key != null) {
            PathWatcher pathWatcher = this.pathWatchers.get(key);
            changed.putAll((Multimap)pathWatcher.update(key.pollEvents(), this.unreadyEvents));
            key.reset();
            key = this.service.poll();
        }
        return changed;
    }

    private void notifySubscribers(String folderName, FileReference file, Name module, Name providingModule, SubscriptionMethod method, SetMultimap<AssetType<?, ?>, ResourceUrn> outChanged) {
        for (SubscriberInfo subscriber : this.subscribers.get((Object)folderName)) {
            Optional<ResourceUrn> urn = method.notify(subscriber.subscriber, file, module, providingModule);
            urn.ifPresent(resourceUrn -> outChanged.put(subscriber.type, resourceUrn));
        }
    }

    private class AssetPathWatcher
    implements PathChangeListener {
        private String assetType;
        private Name module;
        private Name providingModule;

        AssetPathWatcher(String assetType, Name module, Name providingModule) {
            this.assetType = assetType;
            this.module = module;
            this.providingModule = providingModule;
        }

        @Override
        public Optional<? extends PathChangeListener> processPath(String target) {
            return Optional.of(this);
        }

        @Override
        public void onFileCreated(FileReference target, SetMultimap<AssetType<?, ?>, ResourceUrn> outChanged) {
            logger.debug("Asset added: {}", (Object)target);
            ModuleEnvironmentWatcher.this.notifySubscribers(this.assetType, target, this.module, this.providingModule, FileChangeSubscriber::assetFileAdded, outChanged);
        }

        @Override
        public void onFileModified(FileReference target, SetMultimap<AssetType<?, ?>, ResourceUrn> outChanged) {
            logger.debug("Asset modified: {}", (Object)target);
            ModuleEnvironmentWatcher.this.notifySubscribers(this.assetType, target, this.module, this.providingModule, FileChangeSubscriber::assetFileModified, outChanged);
        }

        @Override
        public void onFileDeleted(FileReference target, SetMultimap<AssetType<?, ?>, ResourceUrn> outChanged) {
            logger.debug("Asset deleted: {}", (Object)target);
            ModuleEnvironmentWatcher.this.notifySubscribers(this.assetType, target, this.module, this.providingModule, FileChangeSubscriber::assetFileDeleted, outChanged);
        }
    }

    private class DeltaPathWatcher
    implements PathChangeListener {
        private final Name module;
        private final Name providingModule;
        private final String assetType;

        DeltaPathWatcher(String type, Name module, Name providingModule) {
            this.module = module;
            this.providingModule = providingModule;
            this.assetType = type;
        }

        @Override
        public Optional<? extends PathChangeListener> processPath(String target) throws IOException {
            return Optional.of(this);
        }

        @Override
        public void onFileCreated(FileReference file, SetMultimap<AssetType<?, ?>, ResourceUrn> outChanged) {
            logger.debug("Delta added: {}", (Object)file);
            ModuleEnvironmentWatcher.this.notifySubscribers(this.assetType, file, this.module, this.providingModule, FileChangeSubscriber::deltaFileAdded, outChanged);
        }

        @Override
        public void onFileModified(FileReference file, SetMultimap<AssetType<?, ?>, ResourceUrn> outChanged) {
            logger.debug("Delta modified: {}", (Object)file);
            ModuleEnvironmentWatcher.this.notifySubscribers(this.assetType, file, this.module, this.providingModule, FileChangeSubscriber::deltaFileModified, outChanged);
        }

        @Override
        public void onFileDeleted(FileReference file, SetMultimap<AssetType<?, ?>, ResourceUrn> outChanged) {
            logger.debug("Delta deleted: {}", (Object)file);
            ModuleEnvironmentWatcher.this.notifySubscribers(this.assetType, file, this.module, this.providingModule, FileChangeSubscriber::deltaFileDeleted, outChanged);
        }
    }

    private class DeltaModulePathWatcher
    implements PathChangeListener {
        private Name module;
        private Name providingModule;

        DeltaModulePathWatcher(Name module, Name providingModule) {
            this.module = module;
            this.providingModule = providingModule;
        }

        @Override
        public Optional<? extends PathChangeListener> processPath(String target) {
            return Optional.of(new DeltaPathWatcher(target, this.module, this.providingModule));
        }
    }

    private class DeltaRootPathWatcher
    implements PathChangeListener {
        private Name module;

        DeltaRootPathWatcher(Name module) {
            this.module = module;
        }

        @Override
        public Optional<? extends PathChangeListener> processPath(String target) {
            return Optional.of(new DeltaModulePathWatcher(new Name(target), this.module));
        }
    }

    private class OverrideModulePathWatcher
    implements PathChangeListener {
        private Name module;
        private Name providingModule;

        OverrideModulePathWatcher(Name module, Name providingModule) {
            this.module = module;
            this.providingModule = providingModule;
        }

        @Override
        public Optional<? extends PathChangeListener> processPath(String target) {
            return Optional.of(new AssetPathWatcher(target, this.module, this.providingModule));
        }
    }

    private class OverrideRootPathWatcher
    implements PathChangeListener {
        private Name module;

        OverrideRootPathWatcher(Name module) {
            this.module = module;
        }

        @Override
        public Optional<? extends PathChangeListener> processPath(String target) {
            return Optional.of(new OverrideModulePathWatcher(new Name(target), this.module));
        }
    }

    private class AssetRootPathWatcher
    implements PathChangeListener {
        private Name module;

        AssetRootPathWatcher(Name module) {
            this.module = module;
        }

        @Override
        public Optional<? extends PathChangeListener> processPath(String target) {
            return Optional.of(new AssetPathWatcher(target, this.module, this.module));
        }
    }

    private class RootPathWatcher
    implements PathChangeListener {
        private Name module;

        RootPathWatcher(Name module) {
            this.module = module;
        }

        @Override
        public Optional<? extends PathChangeListener> processPath(String target) throws IOException {
            switch (target) {
                case "assets": {
                    return Optional.of(new AssetRootPathWatcher(this.module));
                }
                case "deltas": {
                    return Optional.of(new DeltaRootPathWatcher(this.module));
                }
                case "overrides": {
                    return Optional.of(new OverrideRootPathWatcher(this.module));
                }
            }
            return Optional.empty();
        }
    }

    private final class PathWatcher {
        private Path watchedPath;
        private Path rootPath;
        private WatchService watchService;
        private PathChangeListener listener;

        private PathWatcher(Path path, Path rootPath, WatchService watchService, PathChangeListener listener) throws IOException {
            this.watchedPath = path;
            this.watchService = watchService;
            this.rootPath = rootPath;
            this.listener = listener;
            WatchKey key = path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            if (key.isValid()) {
                ModuleEnvironmentWatcher.this.pathWatchers.put(key, this);
                ModuleEnvironmentWatcher.this.watchKeys.put(path, key);
            }
        }

        private Path getWatchedPath() {
            return this.watchedPath;
        }

        private SetMultimap<AssetType<?, ?>, ResourceUrn> update(List<WatchEvent<?>> watchEvents, Collection<DelayedEvent> outDelayedEvents) {
            LinkedHashMultimap changedAssets = LinkedHashMultimap.create();
            for (WatchEvent<?> event : watchEvents) {
                DirectoryFileSource.DirectoryFileReference file;
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    logger.warn("File event overflow - lost change events");
                    continue;
                }
                WatchEvent<?> pathEvent = event;
                Path target = this.watchedPath.resolve((Path)pathEvent.context());
                if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                    if (Files.isDirectory(target, new LinkOption[0])) {
                        logger.debug("New directory registered: {}", (Object)target);
                        this.onDirectoryCreated(target, (SetMultimap<AssetType<?, ?>, ResourceUrn>)changedAssets);
                        continue;
                    }
                    if (Files.isRegularFile(target, new LinkOption[0])) {
                        logger.debug("New file registered: {}", (Object)target);
                        file = new DirectoryFileSource.DirectoryFileReference(target.toFile(), this.rootPath.toFile());
                        this.listener.onFileCreated((FileReference)file, (SetMultimap<AssetType<?, ?>, ResourceUrn>)changedAssets);
                        continue;
                    }
                    if (outDelayedEvents == null) continue;
                    outDelayedEvents.add(new DelayedEvent(event, this));
                    continue;
                }
                if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                    if (!Files.isRegularFile(target, new LinkOption[0])) continue;
                    logger.debug("File modified: {}", (Object)target);
                    file = new DirectoryFileSource.DirectoryFileReference(target.toFile(), this.rootPath.toFile());
                    this.listener.onFileModified((FileReference)file, (SetMultimap<AssetType<?, ?>, ResourceUrn>)changedAssets);
                    continue;
                }
                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                WatchKey key = (WatchKey)ModuleEnvironmentWatcher.this.watchKeys.remove(target);
                if (key != null) {
                    ModuleEnvironmentWatcher.this.pathWatchers.remove(key);
                    continue;
                }
                DirectoryFileSource.DirectoryFileReference file2 = new DirectoryFileSource.DirectoryFileReference(target.toFile(), this.rootPath.toFile());
                this.listener.onFileDeleted((FileReference)file2, (SetMultimap<AssetType<?, ?>, ResourceUrn>)changedAssets);
            }
            return changedAssets;
        }

        private void onDirectoryCreated(Path target, SetMultimap<AssetType<?, ?>, ResourceUrn> outChanged) {
            try {
                String relativePath = this.watchedPath.relativize(target).getName(0).toString();
                Optional<? extends PathChangeListener> pathChangeListener = this.listener.processPath(relativePath);
                if (pathChangeListener.isPresent()) {
                    new PathWatcher(target, this.rootPath, this.watchService, pathChangeListener.get()).onCreated(outChanged);
                }
            }
            catch (IOException e) {
                logger.error("Error registering path for change watching '{}'", (Object)this.getWatchedPath(), (Object)e);
            }
        }

        final void onRegistered() {
            try (DirectoryStream<Path> contents = Files.newDirectoryStream(this.getWatchedPath());){
                for (Path path : contents) {
                    String relativePath;
                    Optional<? extends PathChangeListener> pathChangeListener;
                    if (!Files.isDirectory(path, new LinkOption[0]) || !(pathChangeListener = this.listener.processPath(relativePath = this.watchedPath.relativize(path).getName(0).toString())).isPresent()) continue;
                    new PathWatcher(path, this.rootPath, this.watchService, pathChangeListener.get()).onRegistered();
                }
            }
            catch (IOException e) {
                logger.error("Error registering path for change watching '{}'", (Object)this.getWatchedPath(), (Object)e);
            }
        }

        final void onCreated(SetMultimap<AssetType<?, ?>, ResourceUrn> outChanged) {
            try (DirectoryStream<Path> contents = Files.newDirectoryStream(this.getWatchedPath());){
                for (Path path : contents) {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        this.onDirectoryCreated(path, outChanged);
                        continue;
                    }
                    this.listener.onFileCreated((FileReference)new DirectoryFileSource.DirectoryFileReference(path.toFile(), this.rootPath.toFile()), outChanged);
                }
            }
            catch (IOException e) {
                logger.error("Error registering path for change watching '{}'", (Object)this.getWatchedPath(), (Object)e);
            }
        }
    }

    private static class DelayedEvent {
        private WatchEvent<?> event;
        private PathWatcher watcher;

        DelayedEvent(WatchEvent<?> event, PathWatcher watcher) {
            this.event = event;
            this.watcher = watcher;
        }

        SetMultimap<AssetType<?, ?>, ResourceUrn> replay() {
            return this.watcher.update(Collections.singletonList(this.event), null);
        }
    }

    private static class SubscriberInfo {
        final AssetType<?, ?> type;
        final FileChangeSubscriber subscriber;

        SubscriberInfo(AssetType<?, ?> type, FileChangeSubscriber subscriber) {
            this.type = type;
            this.subscriber = subscriber;
        }
    }

    private static interface PathChangeListener {
        public Optional<? extends PathChangeListener> processPath(String var1) throws IOException;

        default public void onFileCreated(FileReference target, SetMultimap<AssetType<?, ?>, ResourceUrn> outChanged) {
        }

        default public void onFileModified(FileReference target, SetMultimap<AssetType<?, ?>, ResourceUrn> outChanged) {
        }

        default public void onFileDeleted(FileReference target, SetMultimap<AssetType<?, ?>, ResourceUrn> outChanged) {
        }
    }

    private static interface SubscriptionMethod {
        public Optional<ResourceUrn> notify(FileChangeSubscriber var1, FileReference var2, Name var3, Name var4);
    }
}

