/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.i18n;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class I18nMap
implements Iterable<Map.Entry<Locale, String>> {
    private final Map<Locale, String> values;

    public I18nMap(Map<Locale, String> values) {
        this.values = ImmutableMap.copyOf(values);
    }

    public I18nMap(String value) {
        this.values = ImmutableMap.of((Object)Locale.getDefault(Locale.Category.DISPLAY), (Object)value);
    }

    public String value() {
        String result = this.values.get(Locale.getDefault(Locale.Category.DISPLAY));
        if (result == null) {
            result = this.values.get(Locale.ENGLISH);
        }
        if (result == null && !this.values.isEmpty()) {
            result = this.values.values().iterator().next();
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public String valueFor(Locale locale) {
        Locale fallbackLocale;
        String result = this.values.get(locale);
        if (result == null && !locale.getVariant().isEmpty()) {
            fallbackLocale = new Locale(locale.getLanguage(), locale.getCountry());
            result = this.values.get(fallbackLocale);
        }
        if (result == null && !locale.getCountry().isEmpty()) {
            fallbackLocale = new Locale(locale.getLanguage());
            result = this.values.get(fallbackLocale);
        }
        if (result == null) {
            result = this.value();
        }
        return result;
    }

    public String toString() {
        return this.value();
    }

    @Override
    public Iterator<Map.Entry<Locale, String>> iterator() {
        return this.values.entrySet().iterator();
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof I18nMap) {
            I18nMap other = (I18nMap)obj;
            return Objects.equals(this.values, other.values);
        }
        return false;
    }
}

