/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.i18n.gson;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.terasology.gestalt.i18n.I18nMap;

public class I18nMapTypeAdapter
implements JsonDeserializer<I18nMap>,
JsonSerializer<I18nMap> {
    public I18nMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive()) {
            return new I18nMap(json.getAsString());
        }
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            HashMap values = Maps.newHashMapWithExpectedSize((int)obj.entrySet().size());
            for (Map.Entry item : obj.entrySet()) {
                if (((JsonElement)item.getValue()).isJsonPrimitive()) {
                    values.put(Locale.forLanguageTag((String)item.getKey()), ((JsonElement)item.getValue()).getAsString());
                    continue;
                }
                throw new JsonParseException("Expected locale string pair, found " + (String)item.getKey() + "'" + item.getValue() + "'");
            }
            return new I18nMap(values);
        }
        throw new JsonParseException("Invalid I18nMap: '" + json + "'");
    }

    public JsonElement serialize(I18nMap src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        for (Map.Entry<Locale, String> item : src) {
            result.addProperty(item.getKey().toLanguageTag(), item.getValue());
        }
        return result;
    }
}

