/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.module.ModuleMetadata;
import org.terasology.gestalt.module.resources.ModuleFileSource;
import org.terasology.gestalt.naming.Name;
import org.terasology.gestalt.naming.Version;

public final class Module {
    private static final Logger logger = LoggerFactory.getLogger(Module.class);
    private final ModuleMetadata metadata;
    private final ModuleFileSource moduleFileSources;
    private final ImmutableList<File> moduleClasspaths;
    private final Predicate<Class<?>> classPredicate;
    private final Reflections moduleManifest;

    public Module(ModuleMetadata metadata, ModuleFileSource fileSources, Collection<File> classpaths, Reflections moduleManifest, Predicate<Class<?>> classPredicate) {
        Preconditions.checkNotNull((Object)metadata);
        Preconditions.checkNotNull((Object)fileSources);
        Preconditions.checkNotNull((Object)moduleManifest);
        Preconditions.checkNotNull(classPredicate);
        this.metadata = metadata;
        this.moduleFileSources = fileSources;
        this.moduleClasspaths = ImmutableList.copyOf(classpaths);
        this.classPredicate = classPredicate;
        this.moduleManifest = moduleManifest;
        moduleManifest.getStore().getOrCreate("ResourcesScanner");
    }

    public ModuleFileSource getResources() {
        return this.moduleFileSources;
    }

    public List<File> getClasspaths() {
        return this.moduleClasspaths;
    }

    public Name getId() {
        return this.metadata.getId();
    }

    public Version getVersion() {
        return this.metadata.getVersion();
    }

    public ImmutableSet<String> getRequiredPermissions() {
        return ImmutableSet.copyOf(this.metadata.getRequiredPermissions());
    }

    public ModuleMetadata getMetadata() {
        return this.metadata;
    }

    public Reflections getModuleManifest() {
        return this.moduleManifest;
    }

    public Predicate<Class<?>> getClassPredicate() {
        return this.classPredicate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Module) {
            Module other = (Module)obj;
            return Objects.equals(other.getId(), this.getId()) && Objects.equals(other.getVersion(), this.getVersion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getVersion());
    }

    public String toString() {
        return this.getId() + "-" + this.getVersion();
    }
}

