/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module;

import android.support.annotation.NonNull;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.module.Module;
import org.terasology.gestalt.module.dependencyresolution.DependencyInfo;
import org.terasology.gestalt.module.resources.CompositeFileSource;
import org.terasology.gestalt.module.resources.ModuleFileSource;
import org.terasology.gestalt.module.sandbox.JavaModuleClassLoader;
import org.terasology.gestalt.module.sandbox.ModuleClassLoader;
import org.terasology.gestalt.module.sandbox.ObtainClassloader;
import org.terasology.gestalt.module.sandbox.PermissionProvider;
import org.terasology.gestalt.module.sandbox.PermissionProviderFactory;
import org.terasology.gestalt.naming.Name;

public class ModuleEnvironment
implements AutoCloseable,
Iterable<Module> {
    private static final Logger logger = LoggerFactory.getLogger(ModuleEnvironment.class);
    private final ImmutableMap<Name, Module> modules;
    private final ClassLoader apiClassLoader;
    private final ClassLoader finalClassLoader;
    private final ImmutableList<ModuleClassLoader> managedClassLoaders;
    private final ImmutableSetMultimap<Name, Name> moduleDependencies;
    private final Reflections fullReflections;
    private final ImmutableList<Module> modulesOrderByDependencies;
    private final ImmutableList<Name> moduleIdsOrderedByDependencies;
    private final ModuleFileSource resources;

    public ModuleEnvironment(Iterable<Module> modules, PermissionProviderFactory permissionProviderFactory) {
        this(modules, permissionProviderFactory, JavaModuleClassLoader::create);
    }

    public ModuleEnvironment(Iterable<Module> modules, PermissionProviderFactory permissionProviderFactory, ClassLoaderSupplier classLoaderSupplier) {
        this(modules, permissionProviderFactory, classLoaderSupplier, ModuleEnvironment.class.getClassLoader());
    }

    public ModuleEnvironment(Iterable<Module> modules, PermissionProviderFactory permissionProviderFactory, ClassLoaderSupplier classLoaderSupplier, ClassLoader apiClassLoader) {
        LinkedHashMap reflectionsByModule = Maps.newLinkedHashMap();
        this.modules = this.buildModuleMap(modules);
        this.apiClassLoader = apiClassLoader;
        this.modulesOrderByDependencies = this.calculateModulesOrderedByDependencies();
        this.moduleIdsOrderedByDependencies = ImmutableList.copyOf((Collection)Collections2.transform(this.modulesOrderByDependencies, Module::getId));
        ImmutableList.Builder managedClassLoaderListBuilder = ImmutableList.builder();
        ClassLoader lastClassLoader = apiClassLoader;
        List<Module> orderedModules = this.getModulesOrderedByDependencies();
        Predicate classpathModuleClassesPredicate = orderedModules.stream().map(Module::getClassPredicate).reduce(x -> false, Predicate::or);
        for (Module module : orderedModules) {
            if (!module.getClasspaths().isEmpty() && !this.hasClassContent(module)) {
                ModuleClassLoader classLoader = this.buildModuleClassLoader(module, lastClassLoader, permissionProviderFactory, classLoaderSupplier, classpathModuleClassesPredicate);
                managedClassLoaderListBuilder.add((Object)classLoader);
                lastClassLoader = classLoader.getClassLoader();
            }
            reflectionsByModule.put(module.getId(), module.getModuleManifest());
        }
        this.finalClassLoader = lastClassLoader;
        this.fullReflections = this.buildFullReflections(reflectionsByModule);
        this.managedClassLoaders = managedClassLoaderListBuilder.build();
        this.moduleDependencies = this.buildModuleDependencies();
        this.resources = new CompositeFileSource(this.getModulesOrderedByDependencies().stream().map(Module::getResources).collect(Collectors.toList()));
    }

    private boolean hasClassContent(Module module) {
        return module.getModuleManifest().getStore().getAll(Utils.index(SubTypesScanner.class), Object.class.getName()).iterator().hasNext();
    }

    private ImmutableMap<Name, Module> buildModuleMap(Iterable<Module> moduleList) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Module module : moduleList) {
            builder.put((Object)module.getId(), (Object)module);
        }
        return builder.build();
    }

    private ModuleClassLoader buildModuleClassLoader(Module module, ClassLoader parent, PermissionProviderFactory permissionProviderFactory, ClassLoaderSupplier classLoaderSupplier, Predicate<Class<?>> classpathModuleClassesPredicate) {
        PermissionProvider permissionProvider = permissionProviderFactory.createPermissionProviderFor(module, classpathModuleClassesPredicate);
        return AccessController.doPrivileged(() -> classLoaderSupplier.create(module, parent, permissionProvider));
    }

    private Reflections buildFullReflections(Map<Name, Reflections> reflectionsByModule) {
        ConfigurationBuilder fullBuilder = new ConfigurationBuilder().addClassLoader(this.finalClassLoader);
        Reflections reflections = new Reflections((Configuration)fullBuilder);
        for (Reflections moduleReflection : reflectionsByModule.values()) {
            reflections.merge(moduleReflection);
        }
        return reflections;
    }

    private ImmutableSetMultimap<Name, Name> buildModuleDependencies() {
        HashMultimap moduleDependenciesBuilder = HashMultimap.create();
        for (Module module : this.getModulesOrderedByDependencies()) {
            for (DependencyInfo dependency : module.getMetadata().getDependencies()) {
                moduleDependenciesBuilder.put((Object)module.getId(), (Object)dependency.getId());
                moduleDependenciesBuilder.putAll((Object)module.getId(), (Iterable)moduleDependenciesBuilder.get((Object)dependency.getId()));
            }
        }
        return ImmutableSetMultimap.copyOf((Multimap)moduleDependenciesBuilder);
    }

    private ImmutableList<Module> calculateModulesOrderedByDependencies() {
        ArrayList result = Lists.newArrayList();
        ArrayList alphabeticallyOrderedModules = Lists.newArrayList((Iterable)this.modules.values());
        alphabeticallyOrderedModules.sort(Comparator.comparing(Module::getId));
        for (Module module : alphabeticallyOrderedModules) {
            this.addModuleAfterDependencies(module, result);
        }
        return ImmutableList.copyOf((Collection)result);
    }

    private void addModuleAfterDependencies(Module module, List<Module> out) {
        if (!out.contains(module)) {
            module.getMetadata().getDependencies().stream().filter(Objects::nonNull).map(DependencyInfo::getId).sorted().forEach(dependency -> {
                Module dependencyModule = (Module)this.modules.get(dependency);
                if (dependencyModule != null) {
                    this.addModuleAfterDependencies(dependencyModule, out);
                }
            });
            out.add(module);
        }
    }

    @Override
    public void close() {
        for (ModuleClassLoader classLoader : this.managedClassLoaders) {
            try {
                classLoader.close();
            }
            catch (IOException e) {
                logger.error("Failed to close classLoader for module '" + classLoader.getModuleId() + "'", (Throwable)e);
            }
        }
    }

    public Module get(Name id) {
        return (Module)this.modules.get((Object)id);
    }

    public final List<Module> getModulesOrderedByDependencies() {
        return this.modulesOrderByDependencies;
    }

    public final List<Name> getModuleIdsOrderedByDependencies() {
        return this.moduleIdsOrderedByDependencies;
    }

    public Name getModuleProviding(Class<?> type) {
        ClassLoader classLoader = AccessController.doPrivileged(new ObtainClassloader(type));
        if (classLoader instanceof ModuleClassLoader) {
            return ((ModuleClassLoader)((Object)classLoader)).getModuleId();
        }
        for (Module module : this.modulesOrderByDependencies) {
            if (!module.getClassPredicate().test(type)) continue;
            return module.getId();
        }
        return null;
    }

    public Set<Name> getDependencyNamesOf(Name moduleId) {
        return this.moduleDependencies.get((Object)moduleId);
    }

    public ModuleFileSource getResources() {
        return this.resources;
    }

    public <U> Iterable<Class<? extends U>> getSubtypesOf(Class<U> type) {
        try {
            return this.fullReflections.getSubTypesOf(type);
        }
        catch (ReflectionsException e) {
            throw new ReflectionsException("Could not obtain subtypes of '" + type + "' - possible subclass without permission", (Throwable)e);
        }
    }

    public <U> Iterable<Class<? extends U>> getSubtypesOf(Class<U> type, Predicate<Class<?>> filter) {
        return this.fullReflections.getSubTypesOf(type).stream().filter(filter).collect(Collectors.toSet());
    }

    public Iterable<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.fullReflections.getTypesAnnotatedWith(annotation, true);
    }

    public Iterable<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, Predicate<Class<?>> filter) {
        return this.fullReflections.getTypesAnnotatedWith(annotation, true).stream().filter(filter).collect(Collectors.toSet());
    }

    @Override
    @NonNull
    public Iterator<Module> iterator() {
        return this.modules.values().iterator();
    }

    @FunctionalInterface
    public static interface ClassLoaderSupplier {
        public ModuleClassLoader create(Module var1, ClassLoader var2, PermissionProvider var3);
    }
}

