/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module;

import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.Reflection;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.serializers.JsonSerializer;
import org.reflections.serializers.Serializer;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.module.Module;
import org.terasology.gestalt.module.ModuleMetadata;
import org.terasology.gestalt.module.ModuleMetadataJsonAdapter;
import org.terasology.gestalt.module.ModuleMetadataLoader;
import org.terasology.gestalt.module.exceptions.InvalidModulePathException;
import org.terasology.gestalt.module.exceptions.MissingModuleMetadataException;
import org.terasology.gestalt.module.resources.ArchiveFileSource;
import org.terasology.gestalt.module.resources.ClasspathFileSource;
import org.terasology.gestalt.module.resources.DirectoryFileSource;

@RequiresApi(value=24)
public class ModuleFactory {
    private static final Logger logger = LoggerFactory.getLogger(ModuleFactory.class);
    private static final Joiner RESOURCE_PATH_JOINER = Joiner.on((char)'/');
    private static final Configuration EMPTY_CONFIG = new ConfigurationBuilder();
    private static final String STANDARD_CODE_SUBPATH = "build/classes";
    private static final String STANDARD_LIBS_SUBPATH = "libs";
    private final Map<String, ModuleMetadataLoader> moduleMetadataLoaderMap = Maps.newLinkedHashMap();
    private final Map<String, Serializer> manifestSerializersByFilename = Maps.newLinkedHashMap();
    private final ClassLoader classLoader;
    private String defaultCodeSubpath;
    private String defaultLibsSubpath;
    private boolean scanningForClasses = true;

    public ModuleFactory() {
        this(ClasspathHelper.contextClassLoader());
    }

    public ModuleFactory(ClassLoader classLoader) {
        this(classLoader, STANDARD_CODE_SUBPATH, STANDARD_LIBS_SUBPATH, (Map<String, ModuleMetadataLoader>)ImmutableMap.of((Object)"module.json", (Object)new ModuleMetadataJsonAdapter()));
    }

    public ModuleFactory(String defaultCodeSubpath, String defaultLibsSubpath) {
        this(ClasspathHelper.contextClassLoader(), defaultCodeSubpath, defaultLibsSubpath, (Map<String, ModuleMetadataLoader>)ImmutableMap.of((Object)"module.json", (Object)new ModuleMetadataJsonAdapter()));
    }

    public ModuleFactory(ClassLoader classLoader, String defaultCodeSubpath, String defaultLibsSubpath, Map<String, ModuleMetadataLoader> metadataLoaders) {
        this.classLoader = classLoader;
        this.moduleMetadataLoaderMap.putAll(metadataLoaders);
        this.defaultCodeSubpath = defaultCodeSubpath;
        this.defaultLibsSubpath = defaultLibsSubpath;
        this.manifestSerializersByFilename.put("manifest.json", (Serializer)new JsonSerializer());
    }

    public String getDefaultCodeSubpath() {
        return this.defaultCodeSubpath;
    }

    public void setDefaultCodeSubpath(String defaultCodeSubpath) {
        this.defaultCodeSubpath = defaultCodeSubpath;
    }

    public boolean isScanningForClasses() {
        return this.scanningForClasses;
    }

    public void setScanningForClasses(boolean scanForClasses) {
        this.scanningForClasses = scanForClasses;
    }

    public String getDefaultLibsSubpath() {
        return this.defaultLibsSubpath;
    }

    public void setDefaultLibsSubpath(String defaultLibsSubpath) {
        this.defaultLibsSubpath = defaultLibsSubpath;
    }

    public void setManifestFileType(String name, Serializer deserializer) {
        this.manifestSerializersByFilename.put(name, deserializer);
    }

    public Map<String, ModuleMetadataLoader> getModuleMetadataLoaderMap() {
        return this.moduleMetadataLoaderMap;
    }

    @NonNull
    private Reflections scanOrLoadClasspathReflections(String packagePath) {
        String path = packagePath;
        if (!path.isEmpty() && !path.endsWith("/")) {
            path = path + "/";
        }
        Reflections manifest = new Reflections(EMPTY_CONFIG);
        try {
            boolean loaded = false;
            for (Map.Entry<String, Serializer> manifestEntry : this.manifestSerializersByFilename.entrySet()) {
                Enumeration<URL> resources = this.classLoader.getResources(path + manifestEntry.getKey());
                while (resources.hasMoreElements()) {
                    InputStream stream = resources.nextElement().openStream();
                    Throwable throwable = null;
                    try {
                        manifest.merge(manifestEntry.getValue().read(stream));
                        loaded = true;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
            }
            if (!loaded && this.scanningForClasses) {
                ConfigurationBuilder config = new ConfigurationBuilder().addScanners(new Scanner[]{new ResourcesScanner(), new SubTypesScanner(false), new TypeAnnotationsScanner()}).addClassLoader(this.classLoader).forPackages(new String[]{packagePath});
                Reflections reflections = new Reflections((Configuration)config);
                manifest.merge(reflections);
            }
        }
        catch (IOException e) {
            logger.error("Failed to gather class manifest for classpath module", (Throwable)e);
        }
        return manifest;
    }

    @NonNull
    private Reflections scanOrLoadDirectoryManifest(File directory) {
        Reflections manifest = new Reflections(EMPTY_CONFIG);
        try {
            boolean loaded = false;
            for (Map.Entry<String, Serializer> manifestEntry : this.manifestSerializersByFilename.entrySet()) {
                File manifestFile = new File(directory, manifestEntry.getKey());
                if (!manifestFile.exists() || !manifestFile.isFile()) continue;
                FileInputStream stream = new FileInputStream(manifestFile);
                Throwable throwable = null;
                try {
                    manifest.merge(manifestEntry.getValue().read((InputStream)stream));
                    loaded = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)stream).close();
                }
            }
            if (!loaded) {
                this.scanContents(directory, manifest);
            }
        }
        catch (IOException e) {
            logger.error("Failed to gather class manifest for classpath module", (Throwable)e);
        }
        return manifest;
    }

    private void scanContents(File directory, Reflections manifest) throws MalformedURLException {
        if (this.scanningForClasses) {
            ConfigurationBuilder config = new ConfigurationBuilder().addScanners(new Scanner[]{new ResourcesScanner(), new SubTypesScanner(false), new TypeAnnotationsScanner()}).addUrls(new URL[]{directory.toURI().toURL()});
            Reflections reflections = new Reflections((Configuration)config);
            manifest.merge(reflections);
        }
    }

    @NonNull
    private Reflections scanOrLoadArchiveManifest(File archive) {
        Reflections manifest = new Reflections(EMPTY_CONFIG);
        try {
            boolean loaded = false;
            try (ZipFile zipFile = new ZipFile(archive);){
                for (Map.Entry<String, Serializer> manifestEntry : this.manifestSerializersByFilename.entrySet()) {
                    ZipEntry modInfoEntry = zipFile.getEntry(manifestEntry.getKey());
                    if (modInfoEntry == null || modInfoEntry.isDirectory()) continue;
                    InputStream stream = zipFile.getInputStream(modInfoEntry);
                    Throwable throwable = null;
                    try {
                        manifest.merge(manifestEntry.getValue().read(stream));
                        loaded = true;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
            }
            if (!loaded) {
                this.scanContents(archive, manifest);
            }
        }
        catch (IOException e) {
            logger.error("Failed to gather class manifest for classpath module", (Throwable)e);
        }
        return manifest;
    }

    public Module createPackageModule(String packageName) {
        ModuleMetadata metadata = null;
        List<String> packageParts = Arrays.asList(packageName.split(Pattern.quote(".")));
        for (Map.Entry<String, ModuleMetadataLoader> metadataEntries : this.moduleMetadataLoaderMap.entrySet()) {
            String metadataResource = RESOURCE_PATH_JOINER.join(packageParts) + "/" + metadataEntries.getKey();
            InputStream metadataStream = this.classLoader.getResourceAsStream(metadataResource);
            if (metadataStream == null) continue;
            try (InputStreamReader reader = new InputStreamReader(metadataStream);){
                metadata = metadataEntries.getValue().read(reader);
                break;
            }
            catch (IOException e) {
                logger.error("Failed to read metadata resource {}", (Object)metadataResource, (Object)e);
            }
        }
        if (metadata != null) {
            return this.createPackageModule(metadata, packageName);
        }
        throw new MissingModuleMetadataException("Missing or failed to load metadata for package module " + packageName);
    }

    public Module createPackageModule(ModuleMetadata metadata, String packageName) {
        List<String> packageParts = Arrays.asList(packageName.split(Pattern.quote(".")));
        Reflections manifest = this.scanOrLoadClasspathReflections(RESOURCE_PATH_JOINER.join(packageParts));
        return new Module(metadata, new ClasspathFileSource(manifest, RESOURCE_PATH_JOINER.join(packageParts), this.classLoader), Collections.emptyList(), manifest, x -> {
            String classPackageName = Reflection.getPackageName((Class)x);
            return packageName.equals(classPackageName) || classPackageName.startsWith(packageName + ".");
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Module createDirectoryModule(File directory) throws IOException {
        Iterator<Map.Entry<String, ModuleMetadataLoader>> iterator = this.moduleMetadataLoaderMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ModuleMetadataLoader> entry = iterator.next();
            File modInfoFile = new File(directory, entry.getKey());
            if (!modInfoFile.exists()) continue;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(modInfoFile), Charsets.UTF_8));){
                Module module = this.createDirectoryModule(entry.getValue().read(reader), directory);
                return module;
            }
            catch (IOException e) {
                logger.error("Error reading module metadata", (Throwable)e);
            }
        }
        throw new IOException("Could not resolve module metadata for module at " + directory);
    }

    public Module createDirectoryModule(ModuleMetadata metadata, File directory) {
        File[] libDirContents;
        File libDir;
        Preconditions.checkArgument((boolean)directory.isDirectory());
        Reflections manifest = new Reflections(EMPTY_CONFIG);
        ArrayList codeLocations = Lists.newArrayList();
        File codeDir = new File(directory, this.getDefaultCodeSubpath());
        if (codeDir.exists() && codeDir.isDirectory()) {
            codeLocations.add(codeDir);
            manifest.merge(this.scanOrLoadDirectoryManifest(codeDir));
        }
        if ((libDir = new File(directory, this.getDefaultLibsSubpath())).exists() && libDir.isDirectory() && libDir.listFiles() != null && (libDirContents = libDir.listFiles()) != null) {
            for (File lib : libDirContents) {
                if (!lib.isFile()) continue;
                codeLocations.add(lib);
                manifest.merge(this.scanOrLoadArchiveManifest(lib));
            }
        }
        return new Module(metadata, new DirectoryFileSource(directory), codeLocations, manifest, x -> false);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Module createArchiveModule(File archive) throws IOException {
        Throwable throwable = null;
        try (ZipFile zipFile = new ZipFile(archive);){
            for (Map.Entry<String, ModuleMetadataLoader> entry : this.moduleMetadataLoaderMap.entrySet()) {
                ZipEntry modInfoEntry = zipFile.getEntry(entry.getKey());
                if (modInfoEntry == null) continue;
                Throwable throwable2 = null;
                try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream(modInfoEntry), Charsets.UTF_8);){
                    ModuleMetadata metadata = entry.getValue().read(reader);
                    Module module = this.createArchiveModule(metadata, archive);
                    return module;
                }
                catch (JsonParseException e) {
                    try {
                        throw new IOException("Failed to read metadata for module " + archive, e);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                }
                {
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throw throwable5;
                        throw new IOException("Missing module metadata in archive module '" + archive + "'");
                    }
                }
            }
        }
    }

    public Module createArchiveModule(ModuleMetadata metadata, File archive) throws IOException {
        Preconditions.checkArgument((boolean)archive.isFile());
        try {
            return new Module(metadata, new ArchiveFileSource(archive, new String[0]), Collections.singletonList(archive), this.scanOrLoadArchiveManifest(archive), x -> false);
        }
        catch (MalformedURLException e) {
            throw new InvalidModulePathException("Unable to convert file path to url for " + archive, e);
        }
    }

    public Module createModule(ModuleMetadata metadata, File path) throws IOException {
        if (path.isDirectory()) {
            return this.createDirectoryModule(metadata, path);
        }
        return this.createArchiveModule(metadata, path);
    }

    public Module createModule(File path) throws IOException {
        Preconditions.checkArgument((boolean)path.exists());
        if (path.isDirectory()) {
            return this.createDirectoryModule(path);
        }
        return this.createArchiveModule(path);
    }
}

