/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.terasology.gestalt.i18n.I18nMap;
import org.terasology.gestalt.module.dependencyresolution.DependencyInfo;
import org.terasology.gestalt.naming.Name;
import org.terasology.gestalt.naming.Version;

public class ModuleMetadata {
    public static final String ID = "id";
    public static final String VERSION = "version";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String DEPENDENCIES = "dependencies";
    public static final String REQUIRED_PERMISSIONS = "requiredPermissions";
    public static final Set<String> RESERVED_IDS = ImmutableSet.of((Object)"id", (Object)"version", (Object)"displayName", (Object)"description", (Object)"dependencies", (Object)"requiredPermissions", (Object[])new String[0]);
    private final Map<String, Object> extensions = Maps.newHashMap();
    private Name id = Name.EMPTY;
    private Version version = Version.DEFAULT;
    private I18nMap displayName = new I18nMap("");
    private I18nMap description = new I18nMap("");
    private Set<String> requiredPermissions = Sets.newLinkedHashSet();
    private List<DependencyInfo> dependencies = Lists.newArrayList();

    public ModuleMetadata() {
    }

    public ModuleMetadata(Name id, Version version) {
        this.id = id;
        this.version = version;
    }

    public Name getId() {
        return this.id;
    }

    public void setId(Name id) {
        this.id = id;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public I18nMap getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(I18nMap displayName) {
        this.displayName = displayName;
    }

    public I18nMap getDescription() {
        return this.description;
    }

    public void setDescription(I18nMap description) {
        this.description = description;
    }

    public Set<String> getRequiredPermissions() {
        return this.requiredPermissions;
    }

    public List<DependencyInfo> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = Lists.newArrayList();
        }
        return this.dependencies;
    }

    public DependencyInfo getDependencyInfo(Name dependencyId) {
        for (DependencyInfo dependency : this.dependencies) {
            if (!Objects.equals(dependencyId, dependency.getId())) continue;
            return dependency;
        }
        return null;
    }

    public <T> T getExtension(String extensionId, Class<T> expectedType) {
        Object extension = this.extensions.get(extensionId);
        if (expectedType.isInstance(extension)) {
            return expectedType.cast(extension);
        }
        return null;
    }

    public void setExtension(String extensionId, Object extension) {
        Preconditions.checkArgument((!RESERVED_IDS.contains(extensionId) ? 1 : 0) != 0, (Object)("Reserved id '" + extensionId + "' cannot be used to identify an extension"));
        this.extensions.put(extensionId, extension);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.displayName, this.description, this.requiredPermissions, this.dependencies, this.extensions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ModuleMetadata) {
            ModuleMetadata other = (ModuleMetadata)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.version, other.version) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.requiredPermissions, other.requiredPermissions) && Objects.equals(this.dependencies, other.dependencies) && Objects.equals(this.extensions, other.extensions);
        }
        return false;
    }
}

