/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.terasology.gestalt.i18n.I18nMap;
import org.terasology.gestalt.i18n.gson.I18nMapTypeAdapter;
import org.terasology.gestalt.module.ModuleMetadata;
import org.terasology.gestalt.module.ModuleMetadataLoader;
import org.terasology.gestalt.module.dependencyresolution.DependencyInfo;
import org.terasology.gestalt.naming.Name;
import org.terasology.gestalt.naming.Version;
import org.terasology.gestalt.naming.gson.NameTypeAdapter;
import org.terasology.gestalt.naming.gson.VersionTypeAdapter;

public class ModuleMetadataJsonAdapter
implements ModuleMetadataLoader {
    private static final Type DEPENDENCY_LIST_TYPE = new TypeToken<List<DependencyInfo>>(){}.getType();
    private static final Type STRING_SET_TYPE = new TypeToken<Set<String>>(){}.getType();
    private final GsonBuilder builder;
    private final Map<String, Type> extensionMap = Maps.newHashMap();
    private volatile Gson cachedGson;

    public ModuleMetadataJsonAdapter() {
        this.builder = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").registerTypeAdapter(Version.class, (Object)new VersionTypeAdapter()).registerTypeAdapter(Name.class, (Object)new NameTypeAdapter()).registerTypeAdapter(I18nMap.class, (Object)new I18nMapTypeAdapter()).registerTypeAdapter(ModuleMetadata.class, (Object)new ModuleMetadataTypeAdapter());
    }

    public void registerExtension(String extensionId, Type extensionType) {
        Preconditions.checkArgument((!ModuleMetadata.RESERVED_IDS.contains(extensionId) ? 1 : 0) != 0, (Object)("Id '" + extensionId + "' is a reserved id and cannot be used for an extension"));
        this.extensionMap.put(extensionId, extensionType);
    }

    public void registerExtension(String extensionId, Type extensionType, Object typeAdapter) {
        this.registerExtension(extensionId, extensionType);
        this.addTypeHandler(extensionType, typeAdapter);
    }

    public void addTypeHandler(Type type, Object typeHandler) {
        if (this.cachedGson != null) {
            this.cachedGson = null;
        }
        this.builder.registerTypeAdapter(type, typeHandler);
    }

    @Override
    public ModuleMetadata read(Reader reader) {
        if (this.cachedGson == null) {
            this.cachedGson = this.builder.create();
        }
        return (ModuleMetadata)this.cachedGson.fromJson(reader, ModuleMetadata.class);
    }

    public void write(ModuleMetadata data, Writer writer) {
        if (this.cachedGson == null) {
            this.cachedGson = this.builder.create();
        }
        this.cachedGson.toJson((Object)data, (Appendable)writer);
    }

    private class ModuleMetadataTypeAdapter
    implements JsonDeserializer<ModuleMetadata>,
    JsonSerializer<ModuleMetadata> {
        private ModuleMetadataTypeAdapter() {
        }

        public ModuleMetadata deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject metadataObject = json.getAsJsonObject();
            ModuleMetadata metadata = new ModuleMetadata();
            block16: for (Map.Entry entry : metadataObject.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "id": {
                        metadata.setId((Name)context.deserialize((JsonElement)entry.getValue(), Name.class));
                        continue block16;
                    }
                    case "version": {
                        metadata.setVersion((Version)context.deserialize((JsonElement)entry.getValue(), Version.class));
                        continue block16;
                    }
                    case "displayName": {
                        metadata.setDisplayName((I18nMap)context.deserialize((JsonElement)entry.getValue(), I18nMap.class));
                        continue block16;
                    }
                    case "description": {
                        metadata.setDescription((I18nMap)context.deserialize((JsonElement)entry.getValue(), I18nMap.class));
                        continue block16;
                    }
                    case "dependencies": {
                        metadata.getDependencies().addAll((List)context.deserialize((JsonElement)entry.getValue(), DEPENDENCY_LIST_TYPE));
                        continue block16;
                    }
                    case "requiredPermissions": {
                        metadata.getRequiredPermissions().addAll((Set)context.deserialize((JsonElement)entry.getValue(), STRING_SET_TYPE));
                        continue block16;
                    }
                }
                Type extensionType = (Type)ModuleMetadataJsonAdapter.this.extensionMap.get(entry.getKey());
                if (extensionType == null) continue;
                Object extensionObject = context.deserialize((JsonElement)entry.getValue(), extensionType);
                metadata.setExtension((String)entry.getKey(), extensionObject);
            }
            return metadata;
        }

        public JsonElement serialize(ModuleMetadata src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.add("id", context.serialize((Object)src.getId()));
            json.add("version", context.serialize((Object)src.getVersion()));
            json.add("displayName", context.serialize((Object)src.getDisplayName()));
            json.add("description", context.serialize((Object)src.getDescription()));
            json.add("dependencies", context.serialize(src.getDependencies()));
            json.add("requiredPermissions", context.serialize(src.getRequiredPermissions()));
            for (String extKey : ModuleMetadataJsonAdapter.this.extensionMap.keySet()) {
                Object extValue = src.getExtension(extKey, Object.class);
                if (extValue == null) continue;
                json.add(extKey, context.serialize(extValue));
            }
            return json;
        }
    }
}

