/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.module.Module;
import org.terasology.gestalt.module.ModuleFactory;
import org.terasology.gestalt.module.ModuleRegistry;
import org.terasology.gestalt.util.Varargs;

public class ModulePathScanner {
    private static final Logger logger = LoggerFactory.getLogger(ModulePathScanner.class);
    private final ModuleFactory moduleFactory;

    public ModulePathScanner() {
        this.moduleFactory = new ModuleFactory();
    }

    public ModulePathScanner(ModuleFactory factory) {
        this.moduleFactory = factory;
    }

    public ModuleFactory getModuleFactory() {
        return this.moduleFactory;
    }

    public void scan(ModuleRegistry registry, File path, File ... additionalPaths) {
        ImmutableSet discoveryPaths = Varargs.combineToSet((Object)path, (Object[])additionalPaths);
        this.scan(registry, (Collection<File>)discoveryPaths);
    }

    public void scan(ModuleRegistry registry, Collection<File> paths) {
        for (File discoveryPath : paths) {
            this.scanModuleDirectories(registry, discoveryPath);
            this.scanModuleArchives(registry, discoveryPath);
        }
    }

    private void scanModuleArchives(ModuleRegistry registry, File discoveryPath) {
        File[] files = discoveryPath.listFiles(x -> !x.isDirectory() && (x.getName().endsWith(".jar") || x.getName().endsWith(".zip")));
        if (files != null) {
            for (File modulePath : files) {
                this.loadModule(registry, modulePath);
            }
        }
    }

    private void scanModuleDirectories(ModuleRegistry registry, File discoveryPath) {
        File[] files = discoveryPath.listFiles(File::isDirectory);
        if (files != null) {
            for (File modulePath : files) {
                this.loadModule(registry, modulePath);
            }
        }
    }

    private void loadModule(ModuleRegistry registry, File modulePath) {
        try {
            Module module = this.moduleFactory.createModule(modulePath);
            if (registry.add(module)) {
                logger.info("Discovered module: {}", (Object)module);
            } else {
                logger.info("Discovered duplicate module: {}-{}, skipping", (Object)module.getId(), (Object)module.getVersion());
            }
        }
        catch (IOException e) {
            logger.warn("Failed to load module at '{}'", (Object)modulePath, (Object)e);
        }
    }
}

