/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.module.Module;
import org.terasology.gestalt.module.ModuleRegistry;
import org.terasology.gestalt.naming.Name;
import org.terasology.gestalt.naming.Version;

public class TableModuleRegistry
implements ModuleRegistry {
    private static final Logger logger = LoggerFactory.getLogger(TableModuleRegistry.class);
    private final Table<Name, Version, Module> modules = HashBasedTable.create();
    private final Map<Name, Module> latestModules = Maps.newHashMap();

    @Override
    public boolean add(Module module) {
        Preconditions.checkNotNull((Object)module);
        if (!this.modules.contains((Object)module.getId(), (Object)module.getVersion())) {
            this.modules.put((Object)module.getId(), (Object)module.getVersion(), (Object)module);
            Module previousLatest = this.latestModules.get(module.getId());
            if (previousLatest == null || previousLatest.getVersion().compareTo(module.getVersion()) <= 0) {
                this.latestModules.put(module.getId(), module);
            }
            return true;
        }
        logger.error("Duplicate module {}-{} discovered", (Object)module.getId(), (Object)module.getVersion());
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Module) {
            Module module = (Module)o;
            if (this.modules.remove((Object)module.getId(), (Object)module.getVersion()) != null) {
                Module latest = this.latestModules.get(module.getId());
                if (latest.getVersion().compareTo(module.getVersion()) == 0) {
                    this.updateLatestFor(module.getId());
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void updateLatestFor(Name moduleId) {
        Module newLatest = null;
        for (Module remainingModule : this.modules.row((Object)moduleId).values()) {
            if (newLatest != null && remainingModule.getVersion().compareTo(newLatest.getVersion()) <= 0) continue;
            newLatest = remainingModule;
        }
        if (newLatest != null) {
            this.latestModules.put(moduleId, newLatest);
        } else {
            this.latestModules.remove(moduleId);
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends Module> c) {
        boolean result = false;
        for (Module module : c) {
            if (!(module instanceof Module)) continue;
            result |= this.add(module);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet modulesToRetain = Sets.newHashSet();
        for (Object o : c) {
            if (!(o instanceof Module)) continue;
            modulesToRetain.add((Module)o);
        }
        boolean changed = false;
        Iterator moduleIterator = this.modules.values().iterator();
        while (moduleIterator.hasNext()) {
            Module next = (Module)moduleIterator.next();
            if (modulesToRetain.contains(next)) continue;
            moduleIterator.remove();
            changed = true;
        }
        if (changed) {
            for (Name name : this.modules.rowKeySet()) {
                this.updateLatestFor(name);
            }
        }
        return changed;
    }

    @Override
    public Set<Name> getModuleIds() {
        return Sets.newLinkedHashSet((Iterable)this.modules.rowKeySet());
    }

    @Override
    public Collection<Module> getModuleVersions(Name id) {
        return Collections.unmodifiableCollection(this.modules.row((Object)id).values());
    }

    @Override
    public Module getLatestModuleVersion(Name id) {
        return this.latestModules.get(id);
    }

    @Override
    public Module getLatestModuleVersion(Name id, Version minVersion, Version maxVersion) {
        Module module = this.latestModules.get(id);
        if (module != null) {
            if (module.getVersion().compareTo(maxVersion) < 0 && module.getVersion().compareTo(minVersion) >= 0) {
                return module;
            }
            if (module.getVersion().compareTo(minVersion) >= 0) {
                Module result = null;
                for (Map.Entry item : this.modules.row((Object)id).entrySet()) {
                    if (((Version)item.getKey()).compareTo(minVersion) < 0 || ((Version)item.getKey()).compareTo(maxVersion) >= 0 || result != null && ((Version)item.getKey()).compareTo(result.getVersion()) <= 0) continue;
                    result = (Module)item.getValue();
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public Module getModule(Name moduleId, Version version) {
        return (Module)this.modules.get((Object)moduleId, (Object)version);
    }

    @Override
    public int size() {
        return this.modules.size();
    }

    @Override
    public boolean isEmpty() {
        return this.modules.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Module) {
            Module module = (Module)o;
            return this.modules.contains((Object)module.getId(), (Object)module.getVersion());
        }
        return false;
    }

    @Override
    public Iterator<Module> iterator() {
        final Iterator it = this.modules.values().iterator();
        return new Iterator<Module>(){
            private Module current;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Module next() {
                this.current = (Module)it.next();
                return this.current;
            }

            @Override
            public void remove() {
                it.remove();
                Module latest = (Module)TableModuleRegistry.this.latestModules.get(this.current.getId());
                if (latest.getVersion().compareTo(this.current.getVersion()) == 0) {
                    TableModuleRegistry.this.updateLatestFor(this.current.getId());
                }
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.modules.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.modules.values().toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.modules.clear();
        this.latestModules.clear();
    }
}

