/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.dependencyresolution;

import java.util.Objects;
import org.terasology.gestalt.naming.Name;
import org.terasology.gestalt.naming.Version;
import org.terasology.gestalt.naming.VersionRange;

public class DependencyInfo {
    private Name id = new Name("");
    private Version minVersion = new Version(1, 0, 0);
    private Version maxVersion;
    private boolean optional;

    public DependencyInfo() {
    }

    public DependencyInfo(DependencyInfo other) {
        this.id = other.id;
        this.minVersion = other.minVersion;
        this.maxVersion = other.maxVersion;
        this.optional = other.optional;
    }

    public Name getId() {
        return this.id;
    }

    public void setId(Name id) {
        this.id = id;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(Version value) {
        this.minVersion = value;
    }

    public Version getMaxVersion() {
        if (this.maxVersion == null) {
            if (this.minVersion.getMajor() == 0) {
                return this.minVersion.getNextMinorVersion();
            }
            return this.minVersion.getNextMajorVersion();
        }
        return this.maxVersion;
    }

    public void setMaxVersion(Version value) {
        this.maxVersion = value;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public VersionRange versionRange() {
        return new VersionRange(this.getMinVersion(), this.getMaxVersion());
    }

    public String toString() {
        return String.format("DependencyInfo [id=%s, minVersion=%s, maxVersion=%s, optional=%s]", this.id, this.minVersion, this.maxVersion, this.optional);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.minVersion, this.maxVersion, this.optional);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DependencyInfo) {
            DependencyInfo other = (DependencyInfo)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.minVersion, other.minVersion) && Objects.equals(this.maxVersion, other.maxVersion) && Objects.equals(this.optional, other.optional);
        }
        return false;
    }
}

