/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.dependencyresolution;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.terasology.gestalt.module.ModuleRegistry;
import org.terasology.gestalt.module.dependencyresolution.OptionalResolutionStrategy;
import org.terasology.gestalt.module.dependencyresolution.ResolutionAttempt;
import org.terasology.gestalt.module.dependencyresolution.ResolutionResult;
import org.terasology.gestalt.naming.Name;
import org.terasology.gestalt.naming.Version;
import org.terasology.gestalt.naming.VersionRange;

public class DependencyResolver {
    private final OptionalResolutionStrategy optionalStrategy;
    private final ModuleRegistry registry;

    public DependencyResolver(ModuleRegistry registry) {
        this(registry, OptionalResolutionStrategy.INCLUDE_IF_REQUIRED);
    }

    public DependencyResolver(ModuleRegistry registry, OptionalResolutionStrategy optionalResolutionStrategy) {
        this.registry = registry;
        this.optionalStrategy = optionalResolutionStrategy;
    }

    public ResolutionResult resolve(Name rootModule, Name ... additionalModules) {
        return this.builder().require(rootModule).requireAll(additionalModules).build();
    }

    public ResolutionResult resolve(Iterable<Name> moduleIds) {
        return this.builder().requireAll(moduleIds).build();
    }

    public ResolutionBuilder builder() {
        return new ResolutionBuilder();
    }

    public class ResolutionBuilder {
        private final Map<Name, Optional<VersionRange>> validVersions = new HashMap<Name, Optional<VersionRange>>();

        public ResolutionBuilder require(Name moduleId) {
            this.validVersions.put(moduleId, Optional.empty());
            return this;
        }

        public ResolutionBuilder requireVersion(Name moduleId, Version version) {
            this.validVersions.put(moduleId, Optional.of(new VersionRange(version, version.getNextPatchVersion())));
            return this;
        }

        public ResolutionBuilder requireVersionRange(Name moduleId, VersionRange range) {
            this.validVersions.put(moduleId, Optional.of(range));
            return this;
        }

        public ResolutionBuilder requireAll(Name[] moduleIds) {
            for (Name name : moduleIds) {
                this.validVersions.put(name, Optional.empty());
            }
            return this;
        }

        public ResolutionBuilder requireAll(Iterable<Name> moduleIds) {
            Iterator<Name> iterator = moduleIds.iterator();
            while (iterator.hasNext()) {
                this.validVersions.put(iterator.next(), Optional.empty());
            }
            return this;
        }

        public ResolutionResult build() {
            ResolutionAttempt attempt = new ResolutionAttempt(DependencyResolver.this.registry, DependencyResolver.this.optionalStrategy);
            return attempt.resolve(this.validVersions);
        }
    }
}

