/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.dependencyresolution;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.terasology.gestalt.module.Module;
import org.terasology.gestalt.module.ModuleRegistry;
import org.terasology.gestalt.module.dependencyresolution.DependencyInfo;
import org.terasology.gestalt.module.dependencyresolution.OptionalResolutionStrategy;
import org.terasology.gestalt.module.dependencyresolution.ResolutionResult;
import org.terasology.gestalt.naming.Name;
import org.terasology.gestalt.naming.Version;
import org.terasology.gestalt.naming.VersionRange;
import org.terasology.gestalt.util.collection.UniqueQueue;

class ResolutionAttempt {
    private final OptionalResolutionStrategy optionalStrategy;
    private final ModuleRegistry registry;
    private Set<Name> rootModules;
    private SetMultimap<Name, PossibleVersion> moduleVersionPool;
    private ListMultimap<Name, Constraint> constraints;
    private UniqueQueue<Constraint> constraintQueue;

    ResolutionAttempt(ModuleRegistry registry, OptionalResolutionStrategy optionalStrategy) {
        this.registry = registry;
        this.optionalStrategy = optionalStrategy;
    }

    ResolutionResult resolve(Map<Name, Optional<VersionRange>> validVersions) {
        this.rootModules = ImmutableSet.copyOf(validVersions.keySet());
        this.populateDomains(validVersions);
        this.populateConstraints();
        if (!this.includesModules(this.rootModules)) {
            return new ResolutionResult(false, Collections.emptySet());
        }
        this.constraintQueue = UniqueQueue.createWithExpectedSize((int)this.constraints.size());
        this.constraintQueue.addAll(this.constraints.values());
        this.processConstraints();
        if (!this.includesModules(this.rootModules)) {
            return new ResolutionResult(false, Collections.emptySet());
        }
        return new ResolutionResult(true, this.finaliseModules());
    }

    private void populateDomains(Map<Name, Optional<VersionRange>> validVersions) {
        this.moduleVersionPool = HashMultimap.create();
        HashSet involvedModules = Sets.newHashSet();
        ArrayDeque moduleQueue = Queues.newArrayDeque();
        for (Name rootModule : this.rootModules) {
            involvedModules.add(rootModule);
            moduleQueue.push(rootModule);
        }
        while (!moduleQueue.isEmpty()) {
            Name id = (Name)moduleQueue.pop();
            for (Module version : this.registry.getModuleVersions(id)) {
                Optional range = validVersions.getOrDefault(version.getId(), Optional.empty());
                if (range.isPresent() && !((VersionRange)range.get()).contains(version.getVersion())) continue;
                this.moduleVersionPool.put((Object)id, (Object)new PossibleVersion(version.getVersion()));
                for (DependencyInfo dependency : version.getMetadata().getDependencies()) {
                    if (!involvedModules.add(dependency.getId())) continue;
                    moduleQueue.push(dependency.getId());
                    this.moduleVersionPool.put((Object)dependency.getId(), (Object)PossibleVersion.OPTIONAL_VERSION);
                }
            }
        }
    }

    private void populateConstraints() {
        this.constraints = ArrayListMultimap.create();
        for (Name name : this.moduleVersionPool.keySet()) {
            LinkedHashSet dependencies = Sets.newLinkedHashSet();
            for (Module module : this.registry.getModuleVersions(name)) {
                dependencies.addAll(module.getMetadata().getDependencies().stream().map(DependencyInfo::getId).collect(Collectors.toList()));
            }
            for (Name dependency : dependencies) {
                HashMap constraintTable = Maps.newHashMapWithExpectedSize((int)this.moduleVersionPool.get((Object)name).size());
                for (PossibleVersion version : this.moduleVersionPool.get((Object)name)) {
                    Module versionedModule;
                    DependencyInfo info;
                    if (!version.getVersion().isPresent() || (info = (versionedModule = this.registry.getModule(name, version.getVersion().get())).getMetadata().getDependencyInfo(dependency)) == null) continue;
                    constraintTable.put(version.getVersion().get(), new CompatibleVersions(info.versionRange(), info.isOptional() && !this.optionalStrategy.isRequired()));
                }
                VersionConstraint constraint = new VersionConstraint(name, dependency, constraintTable);
                this.constraints.put((Object)name, (Object)constraint);
                this.constraints.put((Object)dependency, (Object)constraint);
            }
        }
    }

    private boolean includesModules(Set<Name> modules) {
        for (Name module : modules) {
            if (!this.moduleVersionPool.get((Object)module).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void processConstraints() {
        while (!this.constraintQueue.isEmpty() && this.includesModules(this.rootModules)) {
            Constraint constraint = (Constraint)this.constraintQueue.remove();
            if (this.applyConstraintToDependency(constraint)) {
                for (Constraint relatedConstraint : this.constraints.get((Object)constraint.getTo())) {
                    if (Objects.equals(relatedConstraint, constraint)) continue;
                    this.constraintQueue.add((Object)relatedConstraint);
                }
            }
            if (!this.applyConstraintToDependant(constraint)) continue;
            for (Constraint relatedConstraint : this.constraints.get((Object)constraint.getFrom())) {
                this.constraintQueue.add((Object)relatedConstraint);
            }
        }
    }

    private boolean applyConstraintToDependency(Constraint constraint) {
        return constraint.constrainTo(Collections.unmodifiableSet(this.moduleVersionPool.get((Object)constraint.getFrom())), this.moduleVersionPool.get((Object)constraint.getTo()));
    }

    private boolean applyConstraintToDependant(Constraint constraint) {
        return constraint.constrainFrom(this.moduleVersionPool.get((Object)constraint.getFrom()), Collections.unmodifiableSet(this.moduleVersionPool.get((Object)constraint.getTo())));
    }

    private Set<Module> finaliseModules() {
        LinkedHashSet finalModuleSet = Sets.newLinkedHashSetWithExpectedSize((int)this.moduleVersionPool.keySet().size());
        ArrayDeque moduleQueue = Queues.newArrayDeque();
        for (Name rootModule : this.rootModules) {
            Version latestVersion = this.reduceToFinalVersion(rootModule, true).get();
            Module module = this.registry.getModule(rootModule, latestVersion);
            finalModuleSet.add(module);
            moduleQueue.push(module);
        }
        while (!moduleQueue.isEmpty()) {
            Module module = (Module)moduleQueue.pop();
            for (DependencyInfo dependency : module.getMetadata().getDependencies()) {
                Module dependencyModule;
                Optional<Version> latestVersion = this.reduceToFinalVersion(dependency.getId(), this.optionalStrategy.isDesired());
                if (!latestVersion.isPresent() || !finalModuleSet.add(dependencyModule = this.registry.getModule(dependency.getId(), latestVersion.get()))) continue;
                moduleQueue.push(dependencyModule);
            }
        }
        return finalModuleSet;
    }

    private Optional<Version> reduceToFinalVersion(Name module, boolean includeIfOptional) {
        PossibleVersion version;
        switch (this.moduleVersionPool.get((Object)module).size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return ((PossibleVersion)this.moduleVersionPool.get((Object)module).iterator().next()).getVersion();
            }
        }
        if (!includeIfOptional && this.moduleVersionPool.get((Object)module).contains(PossibleVersion.OPTIONAL_VERSION)) {
            version = PossibleVersion.OPTIONAL_VERSION;
        } else {
            ArrayList versions = Lists.newArrayList((Iterable)this.moduleVersionPool.get((Object)module));
            Collections.sort(versions);
            version = (PossibleVersion)versions.get(versions.size() - 1);
        }
        this.moduleVersionPool.replaceValues((Object)module, Arrays.asList(version));
        this.constraintQueue.addAll((Collection)this.constraints.get((Object)module));
        this.processConstraints();
        return version.getVersion();
    }

    private static class PossibleVersion
    implements Comparable<PossibleVersion> {
        public static final PossibleVersion OPTIONAL_VERSION = new PossibleVersion();
        private final Optional<Version> version;

        private PossibleVersion() {
            this.version = Optional.empty();
        }

        public PossibleVersion(Version version) {
            this.version = Optional.of(version);
        }

        public Optional<Version> getVersion() {
            return this.version;
        }

        @Override
        public int compareTo(PossibleVersion o) {
            if (!this.version.isPresent()) {
                if (o.version.isPresent()) {
                    return -1;
                }
                return 0;
            }
            if (o.version.isPresent()) {
                return this.version.get().compareTo(o.version.get());
            }
            return 1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PossibleVersion) {
                return this.compareTo((PossibleVersion)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.version);
        }
    }

    private static class CompatibleVersions {
        private final VersionRange versionRange;
        private final boolean missingAllowed;

        public CompatibleVersions(VersionRange versionRange, boolean missingAllowed) {
            this.versionRange = versionRange;
            this.missingAllowed = missingAllowed;
        }

        public boolean isCompatible(PossibleVersion version) {
            if (version.getVersion().isPresent()) {
                return this.versionRange.contains(version.getVersion().get());
            }
            return this.missingAllowed;
        }
    }

    private static final class VersionConstraint
    implements Constraint {
        private final Name from;
        private final Name to;
        private final Map<Version, CompatibleVersions> versionCompatibilities;

        private VersionConstraint(Name from, Name to, Map<Version, CompatibleVersions> versionCompatibilities) {
            this.from = from;
            this.to = to;
            this.versionCompatibilities = versionCompatibilities;
        }

        @Override
        public Name getFrom() {
            return this.from;
        }

        @Override
        public Name getTo() {
            return this.to;
        }

        @Override
        public boolean constrainFrom(Set<PossibleVersion> fromVersions, Set<PossibleVersion> toVersions) {
            boolean changed = false;
            Iterator<PossibleVersion> validVersions = fromVersions.iterator();
            while (validVersions.hasNext()) {
                CompatibleVersions compatibility;
                PossibleVersion version = validVersions.next();
                if (!version.getVersion().isPresent() || (compatibility = this.versionCompatibilities.get(version.getVersion().get())) == null) continue;
                boolean valid = false;
                for (PossibleVersion dependencyVersion : toVersions) {
                    if (!compatibility.isCompatible(dependencyVersion)) continue;
                    valid = true;
                    break;
                }
                if (valid) continue;
                validVersions.remove();
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean constrainTo(Set<PossibleVersion> fromVersions, Set<PossibleVersion> toVersions) {
            boolean changed = false;
            Iterator<PossibleVersion> dependencyVersions = toVersions.iterator();
            while (dependencyVersions.hasNext()) {
                PossibleVersion dependencyVersion = dependencyVersions.next();
                boolean valid = false;
                for (PossibleVersion version : fromVersions) {
                    if (version.getVersion().isPresent()) {
                        CompatibleVersions compatibility = this.versionCompatibilities.get(version.getVersion().get());
                        if (compatibility != null && !compatibility.isCompatible(dependencyVersion)) continue;
                        valid = true;
                        break;
                    }
                    valid = true;
                }
                if (valid) continue;
                dependencyVersions.remove();
                changed = true;
            }
            return changed;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof VersionConstraint) {
                VersionConstraint other = (VersionConstraint)obj;
                return Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }

        public String toString() {
            return this.from + "==>" + this.to;
        }
    }

    private static interface Constraint {
        public Name getFrom();

        public Name getTo();

        public boolean constrainFrom(Set<PossibleVersion> var1, Set<PossibleVersion> var2);

        public boolean constrainTo(Set<PossibleVersion> var1, Set<PossibleVersion> var2);
    }
}

