/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.resources;

import android.support.annotation.NonNull;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.terasology.gestalt.module.resources.FileReference;
import org.terasology.gestalt.module.resources.ModuleFileSource;

public class ArchiveFileSource
implements ModuleFileSource {
    private static final String PATH_SEPARATOR = "/";
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private final Map<String, FileReference> contents = Maps.newLinkedHashMap();
    private final SetMultimap<List<String>, String> subpaths = HashMultimap.create();

    public ArchiveFileSource(File file, String ... subpath) throws IOException {
        this(file, (String x) -> !x.endsWith(".class"), subpath);
    }

    public ArchiveFileSource(File file, Predicate<String> contentsFilter, String ... subpath) throws IOException {
        String basePath = this.buildPathString(Arrays.asList(subpath));
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ArchiveFileReference archiveFile;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() && entry.getName().startsWith(basePath)) {
                    List<String> pathParts = Arrays.asList(entry.getName().substring(basePath.length()).split(PATH_SEPARATOR));
                    if (pathParts.get(0).isEmpty()) continue;
                    this.subpaths.put(pathParts.subList(0, pathParts.size() - 1), (Object)pathParts.get(pathParts.size() - 1));
                    continue;
                }
                if (!entry.getName().startsWith(basePath) || !contentsFilter.test((archiveFile = new ArchiveFileReference(file, entry.getName(), basePath)).getName())) continue;
                this.contents.put(entry.getName().substring(basePath.length()), archiveFile);
            }
        }
    }

    private String buildPathString(List<String> subpath) {
        StringBuilder basePathBuilder = new StringBuilder();
        PATH_JOINER.appendTo(basePathBuilder, subpath);
        if (basePathBuilder.length() > 0) {
            basePathBuilder.append(PATH_SEPARATOR);
        }
        return basePathBuilder.toString();
    }

    @Override
    public Optional<FileReference> getFile(List<String> filepath) {
        return Optional.ofNullable(this.contents.get(PATH_JOINER.join(filepath)));
    }

    @Override
    public Collection<FileReference> getFiles() {
        return Collections.unmodifiableCollection(this.contents.values());
    }

    @Override
    public Collection<FileReference> getFilesInPath(boolean recursive, List<String> path) {
        String basePath = this.buildPathString(path);
        return this.contents.entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(basePath) && (recursive || !((String)x.getKey()).substring(basePath.length()).contains(PATH_SEPARATOR))).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public Set<String> getSubpaths(List<String> fromPath) {
        return this.subpaths.get(fromPath);
    }

    @Override
    @NonNull
    public Iterator<FileReference> iterator() {
        return this.contents.values().iterator();
    }

    private static class ArchiveFileReference
    implements FileReference {
        private File zipFile;
        private String internalFile;
        private String basePath;

        ArchiveFileReference(File zipFile, String internalFile, String basePath) {
            this.zipFile = zipFile;
            this.internalFile = internalFile;
            this.basePath = basePath;
        }

        @Override
        public String getName() {
            int lastPathSeparator = this.internalFile.lastIndexOf(ArchiveFileSource.PATH_SEPARATOR);
            if (lastPathSeparator >= 0) {
                return this.internalFile.substring(lastPathSeparator + 1);
            }
            return this.internalFile;
        }

        @Override
        public List<String> getPath() {
            List<String> parts = Arrays.asList(this.internalFile.substring(this.basePath.length()).split(ArchiveFileSource.PATH_SEPARATOR));
            return parts.subList(0, parts.size() - 1);
        }

        @Override
        public InputStream open() throws IOException {
            ZipFile zip = new ZipFile(this.zipFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().equals(this.internalFile)) continue;
                return zip.getInputStream(entry);
            }
            throw new FileNotFoundException("Could not find file " + this.internalFile + " in " + this.zipFile.getPath());
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            return Objects.hash(this.zipFile, this.internalFile, this.basePath);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ArchiveFileReference) {
                ArchiveFileReference other = (ArchiveFileReference)o;
                return Objects.equals(this.zipFile, other.zipFile) && Objects.equals(this.internalFile, other.internalFile) && Objects.equals(this.basePath, other.basePath);
            }
            return false;
        }
    }
}

