/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.resources;

import android.support.annotation.NonNull;
import com.google.common.base.Joiner;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.terasology.gestalt.module.resources.FileReference;
import org.terasology.gestalt.module.resources.ModuleFileSource;

public class ClasspathFileSource
implements ModuleFileSource {
    private static final String CLASS_PATH_SEPARATOR = "/";
    private static final Joiner CLASS_PATH_JOINER = Joiner.on((String)"/");
    private final Reflections manifest;
    private final String basePath;
    private final ClassLoader classLoader;

    public ClasspathFileSource(Reflections resourceManifest) {
        this(resourceManifest, CLASS_PATH_SEPARATOR, ClassLoader.getSystemClassLoader());
    }

    public ClasspathFileSource(Reflections resourceManifest, String basePath) {
        this(resourceManifest, basePath, ClassLoader.getSystemClassLoader());
    }

    public ClasspathFileSource(Reflections resourceManifest, String basePath, ClassLoader classLoader) {
        this.manifest = resourceManifest;
        this.classLoader = classLoader;
        String path = basePath;
        if (!path.isEmpty() && !path.endsWith(CLASS_PATH_SEPARATOR)) {
            path = path + CLASS_PATH_SEPARATOR;
        }
        if (path.startsWith(CLASS_PATH_SEPARATOR)) {
            path = path.substring(1);
        }
        this.basePath = path;
    }

    @Override
    public Optional<FileReference> getFile(List<String> filepath) {
        String path = this.basePath + CLASS_PATH_JOINER.join(filepath);
        return this.manifest.getResources(x -> true).stream().filter(path::equals).map(x -> new ClasspathSourceFileReference((String)x, this.extractSubpath((String)x), this.classLoader)).findAny();
    }

    @Override
    public Collection<FileReference> getFilesInPath(boolean recursive, List<String> path) {
        String fullPath = this.buildPathString(path);
        return this.manifest.getResources(x -> true).stream().filter(x -> x.startsWith(fullPath) && (recursive || !x.substring(fullPath.length()).contains(CLASS_PATH_SEPARATOR))).map(x -> new ClasspathSourceFileReference((String)x, this.extractSubpath((String)x), this.classLoader)).collect(Collectors.toList());
    }

    @Override
    public Set<String> getSubpaths(List<String> path) {
        String fullPath = this.buildPathString(path);
        return this.manifest.getResources(x -> true).stream().filter(x -> x.startsWith(fullPath) && x.substring(fullPath.length()).contains(CLASS_PATH_SEPARATOR)).map(x -> {
            String subpath = x.substring(fullPath.length());
            return subpath.substring(0, subpath.indexOf(CLASS_PATH_SEPARATOR));
        }).collect(Collectors.toSet());
    }

    private String buildPathString(List<String> path) {
        String fullPath = path.isEmpty() || path.size() == 1 && path.get(0).isEmpty() ? this.basePath : this.basePath + CLASS_PATH_JOINER.join(path) + CLASS_PATH_SEPARATOR;
        return fullPath;
    }

    private String extractSubpath(String path) {
        return path.substring(this.basePath.length());
    }

    @Override
    @NonNull
    public Iterator<FileReference> iterator() {
        return this.getFiles().iterator();
    }

    private static class ClasspathSourceFileReference
    implements FileReference {
        private final String path;
        private final String subpath;
        private final ClassLoader classLoader;

        ClasspathSourceFileReference(String resourcePath, String subpath, ClassLoader classLoader) {
            this.path = resourcePath;
            this.subpath = subpath;
            this.classLoader = classLoader;
        }

        @Override
        public String getName() {
            return this.subpath.substring(this.subpath.lastIndexOf(ClasspathFileSource.CLASS_PATH_SEPARATOR) + 1);
        }

        @Override
        public List<String> getPath() {
            List<String> parts = Arrays.asList(this.subpath.split(ClasspathFileSource.CLASS_PATH_SEPARATOR));
            return parts.subList(0, parts.size() - 1);
        }

        @Override
        public InputStream open() {
            return this.classLoader.getResourceAsStream(this.path);
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            return Objects.hash(this.path, this.classLoader);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ClasspathSourceFileReference) {
                ClasspathSourceFileReference other = (ClasspathSourceFileReference)o;
                return Objects.equals(other.path, this.path) && Objects.equals(other.classLoader, this.classLoader);
            }
            return false;
        }
    }
}

