/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.resources;

import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.terasology.gestalt.module.resources.FileReference;
import org.terasology.gestalt.module.resources.ModuleFileSource;
import org.terasology.gestalt.util.Varargs;

public class CompositeFileSource
implements ModuleFileSource {
    private final List<ModuleFileSource> sources;

    public CompositeFileSource(ModuleFileSource source, ModuleFileSource ... sources) {
        this.sources = Varargs.combineToList((Object)source, (Object[])sources);
    }

    public CompositeFileSource(List<ModuleFileSource> sources) {
        this.sources = ImmutableList.copyOf(sources);
    }

    @Override
    public Optional<FileReference> getFile(List<String> filepath) {
        for (ModuleFileSource source : this.sources) {
            Optional<FileReference> result = source.getFile(filepath);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Override
    public Collection<FileReference> getFiles() {
        return this.sources.stream().flatMap(x -> x.getFiles().stream()).collect(Collectors.toList());
    }

    @Override
    public Collection<FileReference> getFilesInPath(boolean recursive, List<String> path) {
        return this.sources.stream().flatMap(x -> x.getFilesInPath(recursive, path).stream()).collect(Collectors.toList());
    }

    @Override
    public Set<String> getSubpaths(List<String> fromPath) {
        return this.sources.stream().flatMap(x -> x.getSubpaths(fromPath).stream()).collect(Collectors.toSet());
    }

    @Override
    @NonNull
    public Iterator<FileReference> iterator() {
        return this.sources.stream().flatMap(x -> x.getFiles().stream()).iterator();
    }

    @Override
    @RequiresApi(value=26)
    public List<Path> getRootPaths() {
        return this.sources.stream().flatMap(x -> x.getRootPaths().stream()).collect(Collectors.toList());
    }
}

