/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.resources;

import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.module.exceptions.InvalidModulePathException;
import org.terasology.gestalt.module.resources.FileReference;
import org.terasology.gestalt.module.resources.ModuleFileSource;

public class DirectoryFileSource
implements ModuleFileSource {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryFileSource.class);
    private final File rootDirectory;
    private final Predicate<File> filter;

    public DirectoryFileSource(File directory) {
        this(directory, x -> !x.getName().endsWith(".class"));
    }

    public DirectoryFileSource(File directory, Predicate<File> contentFilter) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)"Not a directory");
        this.filter = contentFilter;
        try {
            this.rootDirectory = directory.getCanonicalFile();
        }
        catch (IOException e) {
            throw new InvalidModulePathException("Failed to canonicalize file " + directory, e);
        }
    }

    @Override
    public Collection<FileReference> getFiles() {
        return Lists.newArrayList((Iterator)new DirectoryIterator(this.rootDirectory, this.rootDirectory, this.filter, true));
    }

    @Override
    public Optional<FileReference> getFile(List<String> filepath) {
        File file = this.buildFilePath(filepath);
        try {
            if (!file.getCanonicalPath().startsWith(this.rootDirectory.getPath())) {
                return Optional.empty();
            }
        }
        catch (IOException e) {
            return Optional.empty();
        }
        if (file.isFile() && this.filter.test(file)) {
            return Optional.of(new DirectoryFileReference(file, this.rootDirectory));
        }
        return Optional.empty();
    }

    private File buildFilePath(List<String> filepath) {
        File file = this.rootDirectory;
        for (String part : filepath) {
            file = new File(file, part);
        }
        return file;
    }

    @Override
    public Collection<FileReference> getFilesInPath(boolean recursive, List<String> path) {
        File dir = this.buildFilePath(path);
        try {
            if (!dir.getCanonicalPath().startsWith(this.rootDirectory.getPath())) {
                return Collections.emptyList();
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterator)new DirectoryIterator(this.rootDirectory, dir, this.filter, recursive));
    }

    @Override
    public Set<String> getSubpaths(List<String> fromPath) {
        File dir = this.buildFilePath(fromPath);
        try {
            File[] contents;
            if (dir.getCanonicalPath().startsWith(this.rootDirectory.getPath()) && (contents = dir.listFiles()) != null) {
                return Arrays.stream(contents).filter(File::isDirectory).map(File::getName).collect(Collectors.toSet());
            }
        }
        catch (IOException e) {
            logger.error("Failed to canonicalize path", (Throwable)e);
        }
        return Collections.emptySet();
    }

    @Override
    @RequiresApi(value=26)
    public List<Path> getRootPaths() {
        return Collections.singletonList(this.rootDirectory.toPath());
    }

    @Override
    @NonNull
    public Iterator<FileReference> iterator() {
        return new DirectoryIterator(this.rootDirectory, this.rootDirectory, this.filter, true);
    }

    private static class DirectoryIterator
    implements Iterator<FileReference> {
        private Deque<File> files = Queues.newArrayDeque();
        private FileReference next;
        private Predicate<File> filter;
        private boolean recursive;
        private File rootDirectory;

        DirectoryIterator(File rootDirectory, File baseDirectory, Predicate<File> filter, boolean recursive) {
            this.filter = filter;
            this.recursive = recursive;
            this.rootDirectory = rootDirectory;
            this.addDirectoryContentsToQueue(baseDirectory);
            this.findNext();
        }

        private void findNext() {
            this.next = null;
            while (this.next == null && !this.files.isEmpty()) {
                File file = this.files.pop();
                if (file.isDirectory() && this.recursive) {
                    this.addDirectoryContentsToQueue(file);
                    continue;
                }
                if (!file.isFile() || !this.filter.test(file)) continue;
                this.next = new DirectoryFileReference(file, this.rootDirectory);
            }
        }

        private void addDirectoryContentsToQueue(File file) {
            File[] contents = file.listFiles();
            if (contents != null) {
                this.files.addAll(Arrays.asList(contents));
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public FileReference next() {
            FileReference result = this.next;
            this.findNext();
            return result;
        }
    }

    public static class DirectoryFileReference
    implements FileReference {
        private final File baseDirectory;
        private final File file;

        public DirectoryFileReference(File file, File baseDirectory) {
            this.file = file;
            this.baseDirectory = baseDirectory;
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public List<String> getPath() {
            try {
                String filePath = this.file.getParentFile().getCanonicalPath();
                String basePath = this.baseDirectory.getPath();
                return Arrays.asList(filePath.substring(basePath.length() + 1).split(Pattern.quote(File.separator)));
            }
            catch (IOException e) {
                logger.warn("Failed to canonicalize path", (Throwable)e);
                return Collections.emptyList();
            }
        }

        @Override
        public InputStream open() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DirectoryFileReference) {
                DirectoryFileReference other = (DirectoryFileReference)o;
                return Objects.equals(other.file, this.file);
            }
            return false;
        }
    }
}

