/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.sandbox;

import com.google.common.reflect.Reflection;
import org.reflections.Reflections;
import org.terasology.gestalt.module.sandbox.API;
import org.terasology.gestalt.module.sandbox.PermissionSet;
import org.terasology.gestalt.module.sandbox.StandardPermissionProviderFactory;

public class APIScanner {
    private StandardPermissionProviderFactory permissionProviderFactory;
    private ClassLoader forClassLoader;

    public APIScanner(StandardPermissionProviderFactory permissionProviderFactory) {
        this(permissionProviderFactory, ClassLoader.getSystemClassLoader());
    }

    public APIScanner(StandardPermissionProviderFactory permissionProviderFactory, ClassLoader forClassLoader) {
        this.permissionProviderFactory = permissionProviderFactory;
        this.forClassLoader = forClassLoader;
    }

    public void scan(Reflections manifest) {
        for (Class apiClass : manifest.getTypesAnnotatedWith(API.class, true)) {
            if (this.forClassLoader != apiClass.getClassLoader()) continue;
            for (String permissionSetId : apiClass.getAnnotation(API.class).permissionSet()) {
                PermissionSet permissionSet = this.permissionProviderFactory.getPermissionSet(permissionSetId);
                if (permissionSet == null) {
                    permissionSet = new PermissionSet();
                    this.permissionProviderFactory.addPermissionSet(permissionSetId, permissionSet);
                }
                if (apiClass.isSynthetic()) {
                    permissionSet.addAPIPackage(Reflection.getPackageName((Class)apiClass));
                    continue;
                }
                permissionSet.addAPIClass(apiClass);
            }
        }
    }
}

