/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.sandbox;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.module.Module;
import org.terasology.gestalt.module.sandbox.BytecodeInjector;
import org.terasology.gestalt.module.sandbox.ModuleClassLoader;
import org.terasology.gestalt.module.sandbox.ObtainClassloader;
import org.terasology.gestalt.module.sandbox.PermissionProvider;
import org.terasology.gestalt.naming.Name;

public class JavaModuleClassLoader
extends URLClassLoader
implements ModuleClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(JavaModuleClassLoader.class);
    private final PermissionProvider permissionProvider;
    private final ClassPool pool;
    private final Name moduleId;
    private final List<BytecodeInjector> bytecodeInjectors;

    public JavaModuleClassLoader(Name module, URL[] urls, ClassLoader parent, PermissionProvider permissionProvider) {
        this(module, urls, parent, permissionProvider, Collections.emptyList());
    }

    public JavaModuleClassLoader(Name module, URL[] urls, ClassLoader parent, PermissionProvider permissionProvider, Iterable<BytecodeInjector> injectors) {
        super(urls, parent);
        this.moduleId = module;
        this.permissionProvider = permissionProvider;
        this.bytecodeInjectors = ImmutableList.copyOf(injectors);
        if (!this.bytecodeInjectors.isEmpty()) {
            this.pool = new ClassPool(ClassPool.getDefault());
            for (URL url : urls) {
                try {
                    logger.debug("Module path: {}", (Object)url.toURI());
                    this.pool.appendClassPath(new File(url.toURI()).toString());
                }
                catch (URISyntaxException | NotFoundException e) {
                    logger.error("Failed to process module url: {}", (Object)url);
                }
            }
        } else {
            this.pool = null;
        }
    }

    public static ModuleClassLoader create(Module module, ClassLoader parent, PermissionProvider permissionProvider) {
        URL[] urls = (URL[])module.getClasspaths().stream().map(x -> {
            try {
                return x.toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.error("Failed to code location {} to URL", x, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new);
        return new JavaModuleClassLoader(module.getId(), urls, parent, permissionProvider);
    }

    @Override
    public Name getModuleId() {
        return this.moduleId;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }

    @Override
    public PermissionProvider getPermissionProvider() {
        return this.permissionProvider;
    }

    private ClassLoader getBaseClassLoader() {
        if (this.getParent() instanceof ModuleClassLoader) {
            return ((JavaModuleClassLoader)this.getParent()).getBaseClassLoader();
        }
        return this.getParent();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = this.getBaseClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            clazz = super.loadClass(name, resolve);
        }
        ClassLoader parentLoader = AccessController.doPrivileged(new ObtainClassloader(clazz));
        if (parentLoader != this && !(parentLoader instanceof ModuleClassLoader)) {
            if (this.permissionProvider.isPermitted(clazz)) {
                return clazz;
            }
            logger.error("Denied access to class (not allowed with this module's permissions): {}", (Object)name);
            return null;
        }
        return clazz;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("java.")) {
            return null;
        }
        try {
            if (this.pool != null) {
                return AccessController.doPrivileged(() -> {
                    CtClass cc = this.pool.get(name);
                    for (BytecodeInjector injector : this.bytecodeInjectors) {
                        injector.inject(cc);
                    }
                    byte[] b = cc.toBytecode();
                    return this.defineClass(name, b, 0, b.length);
                });
            }
            return super.findClass(name);
        }
        catch (PrivilegedActionException e) {
            throw new ClassNotFoundException("Failed to find or load class " + name, e.getCause());
        }
    }
}

