/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.sandbox;

import java.security.Permission;
import org.terasology.gestalt.module.sandbox.ModuleClassLoader;
import org.terasology.gestalt.module.sandbox.ModuleSecurityPermission;
import org.terasology.gestalt.module.sandbox.PermissionProvider;

public class ModuleSecurityManager
extends SecurityManager {
    public static final Permission UPDATE_ALLOWED_PERMISSIONS = new ModuleSecurityPermission("updateAllowedPermission");
    public static final Permission UPDATE_API_CLASSES = new ModuleSecurityPermission("updateAPIClasses");
    private ThreadLocal<Boolean> calculatingPermission = new ThreadLocal();

    @Override
    public void checkPermission(Permission perm) {
        if (this.checkModuleDeniedAccess(perm)) {
            super.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.checkModuleDeniedAccess(perm)) {
            super.checkPermission(perm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkModuleDeniedAccess(Permission perm) {
        if (this.calculatingPermission.get() != null) {
            return false;
        }
        this.calculatingPermission.set(true);
        try {
            Class<?>[] stack = this.getClassContext();
            for (int i = 0; i < stack.length; ++i) {
                ClassLoader owningLoader = stack[i].getClassLoader();
                if (owningLoader == null || !(owningLoader instanceof ModuleClassLoader)) continue;
                boolean bl = !this.checkAPIPermissionsFor(perm, i, stack, ((ModuleClassLoader)((Object)owningLoader)).getPermissionProvider());
                return bl;
            }
        }
        finally {
            this.calculatingPermission.set(null);
        }
        return true;
    }

    private boolean checkAPIPermissionsFor(Permission permission, int moduleDepth, Class<?>[] stack, PermissionProvider permissionProvider) {
        for (int i = moduleDepth - 1; i >= 0; --i) {
            if (!permissionProvider.isPermitted(permission, stack[i])) continue;
            return true;
        }
        return false;
    }
}

