/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.sandbox;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.Reflection;
import java.security.Permission;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.module.sandbox.ModuleSecurityManager;
import org.terasology.gestalt.module.sandbox.PermissionProvider;

public class PermissionSet
implements PermissionProvider {
    private static final Logger logger = LoggerFactory.getLogger(PermissionSet.class);
    private final Set<Class<?>> apiClasses = Sets.newHashSet();
    private final Set<String> apiPackages = Sets.newHashSet();
    private final Set<Class<? extends Permission>> globallyAllowedPermissionsTypes = Sets.newHashSet();
    private final Set<Permission> globallyAllowedPermissionsInstances = Sets.newHashSet();
    private final SetMultimap<Class<? extends Permission>, Class<?>> allowedPermissionsTypes = HashMultimap.create();
    private final SetMultimap<Permission, Class<?>> allowedPermissionInstances = HashMultimap.create();
    private final SetMultimap<Class<? extends Permission>, String> allowedPackagePermissionsTypes = HashMultimap.create();
    private final SetMultimap<Permission, String> allowedPackagePermissionInstances = HashMultimap.create();

    @Override
    public boolean isPermitted(Class<?> type) {
        return this.apiClasses.contains(type) || this.apiPackages.contains(Reflection.getPackageName(type));
    }

    @Override
    public boolean isPermitted(Permission permission, Class<?> context) {
        return this.globallyAllowedPermissionsTypes.contains(permission.getClass()) || this.globallyAllowedPermissionsInstances.contains(permission) || this.allowedPermissionInstances.get((Object)permission).contains(context) || this.allowedPermissionsTypes.get(permission.getClass()).contains(context) || this.allowedPackagePermissionInstances.get((Object)permission).contains(Reflection.getPackageName(context)) || this.allowedPackagePermissionsTypes.get(permission.getClass()).contains(Reflection.getPackageName(context));
    }

    public void grantPermission(Class<? extends Permission> permission) {
        Preconditions.checkNotNull(permission);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        this.globallyAllowedPermissionsTypes.add(permission);
        logger.debug("Globally granted permission '{}'", permission);
    }

    public void grantPermission(Permission permission) {
        Preconditions.checkNotNull((Object)permission);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        this.globallyAllowedPermissionsInstances.add(permission);
        logger.debug("Globally granted permission '{}'", (Object)permission);
    }

    public void grantPermission(Class<?> apiType, Class<? extends Permission> permission) {
        Preconditions.checkNotNull(apiType);
        Preconditions.checkNotNull(permission);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        this.allowedPermissionsTypes.put(permission, apiType);
        logger.debug("Granted permission '{}' to '{}'", permission, apiType);
    }

    public void grantPermission(Class<?> apiType, Permission permission) {
        Preconditions.checkNotNull(apiType);
        Preconditions.checkNotNull((Object)permission);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        this.allowedPermissionInstances.put((Object)permission, apiType);
        logger.debug("Granted permission '{}' to '{}'", (Object)permission, apiType);
    }

    public void grantPermission(String packageName, Class<? extends Permission> permission) {
        Preconditions.checkNotNull((Object)packageName);
        Preconditions.checkNotNull(permission);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        this.allowedPackagePermissionsTypes.put(permission, (Object)packageName);
        logger.debug("Granted permission '{}' to '{}.*'", permission, (Object)packageName);
    }

    public void grantPermission(String packageName, Permission permission) {
        Preconditions.checkNotNull((Object)packageName);
        Preconditions.checkNotNull((Object)permission);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        this.allowedPackagePermissionInstances.put((Object)permission, (Object)packageName);
        logger.debug("Granted permission '{}' to '{}.*'", (Object)permission, (Object)packageName);
    }

    public void addAPIClass(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_API_CLASSES);
        }
        this.apiClasses.add(clazz);
        logger.debug("Added API class '{}'", clazz);
    }

    public void addAPIPackage(String packageName) {
        Preconditions.checkNotNull((Object)packageName);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        this.apiPackages.add(packageName);
        logger.debug("Added API classes '{}.*'", (Object)packageName);
    }

    public boolean revokePermission(Class<? extends Permission> permission) {
        Preconditions.checkNotNull(permission);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        logger.debug("Revoking global permission '{}'", permission);
        return this.globallyAllowedPermissionsTypes.remove(permission);
    }

    public boolean revokePermission(Permission permission) {
        Preconditions.checkNotNull((Object)permission);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        logger.debug("Revoking global permission '{}'", (Object)permission);
        return this.globallyAllowedPermissionsInstances.remove(permission);
    }

    public boolean revokePermission(Class<?> apiType, Class<? extends Permission> permission) {
        Preconditions.checkNotNull(apiType);
        Preconditions.checkNotNull(permission);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        logger.debug("Revoking permission '{}' from '{}'", permission, apiType);
        return this.allowedPermissionsTypes.remove(permission, apiType);
    }

    public boolean revokePermission(Class<?> apiType, Permission permission) {
        Preconditions.checkNotNull(apiType);
        Preconditions.checkNotNull((Object)permission);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        logger.debug("Revoking permission '{}' from '{}'", (Object)permission, apiType);
        return this.allowedPermissionInstances.remove((Object)permission, apiType);
    }

    public void revokePermission(String packageName, Class<? extends Permission> permission) {
        Preconditions.checkNotNull((Object)packageName);
        Preconditions.checkNotNull(permission);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        logger.debug("Revoking permission '{}' from '{}.*'", permission, (Object)packageName);
        this.allowedPackagePermissionsTypes.remove(permission, (Object)packageName);
        Iterator iterator = this.allowedPermissionsTypes.get(permission).iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (!packageName.equals(Reflection.getPackageName((Class)clazz))) continue;
            iterator.remove();
        }
    }

    public void revokePermission(String packageName, Permission permission) {
        Preconditions.checkNotNull((Object)packageName);
        Preconditions.checkNotNull((Object)permission);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        logger.debug("Revoking permission '{}' from '{}.*'", (Object)permission, (Object)packageName);
        this.allowedPackagePermissionInstances.remove((Object)permission, (Object)packageName);
        Iterator iterator = this.allowedPermissionInstances.get((Object)permission).iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (!packageName.equals(Reflection.getPackageName((Class)clazz))) continue;
            iterator.remove();
        }
    }

    public boolean revokeAPIClass(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_API_CLASSES);
        }
        logger.debug("Removing from API '{}'", clazz);
        return this.apiClasses.remove(clazz);
    }

    public void revokeAPIPackage(String packageName) {
        Preconditions.checkNotNull((Object)packageName);
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(ModuleSecurityManager.UPDATE_ALLOWED_PERMISSIONS);
        }
        logger.debug("Removing from API '{}.*'", (Object)packageName);
        this.apiPackages.remove(packageName);
        Iterator<Class<?>> iterator = this.apiClasses.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            if (!packageName.equals(Reflection.getPackageName(clazz))) continue;
            iterator.remove();
        }
    }
}

