/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.sandbox;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.module.Module;
import org.terasology.gestalt.module.sandbox.PermissionProvider;
import org.terasology.gestalt.module.sandbox.PermissionProviderFactory;
import org.terasology.gestalt.module.sandbox.PermissionSet;
import org.terasology.gestalt.module.sandbox.PredicatePermissionProvider;
import org.terasology.gestalt.module.sandbox.SetUnionPermissionProvider;

public class StandardPermissionProviderFactory
implements PermissionProviderFactory {
    public static final String BASE_PERMISSION_SET = "";
    private static final Logger logger = LoggerFactory.getLogger(StandardPermissionProviderFactory.class);
    private final Map<String, PermissionSet> permissionSets = Maps.newHashMap();

    public StandardPermissionProviderFactory() {
        this.permissionSets.put(BASE_PERMISSION_SET, new PermissionSet());
    }

    public PermissionSet getBasePermissionSet() {
        return this.getPermissionSet(BASE_PERMISSION_SET);
    }

    public PermissionSet getPermissionSet(String name) {
        return this.permissionSets.get(name);
    }

    public void addPermissionSet(String name, PermissionSet permissionSet) {
        this.permissionSets.put(name, permissionSet);
    }

    @Override
    public PermissionProvider createPermissionProviderFor(Module module, Predicate<Class<?>> isClasspathModuleClass) {
        ArrayList grantedPermissionSets = Lists.newArrayList();
        grantedPermissionSets.add(this.getBasePermissionSet());
        for (String permissionSetId : module.getRequiredPermissions()) {
            PermissionSet set = this.getPermissionSet(permissionSetId);
            if (set != null) {
                grantedPermissionSets.add(set);
                continue;
            }
            logger.warn("Module '{}' requires unknown permission '{}'", (Object)module, (Object)permissionSetId);
        }
        grantedPermissionSets.add(new PredicatePermissionProvider(isClasspathModuleClass));
        return new SetUnionPermissionProvider(grantedPermissionSets);
    }
}

