/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.module.sandbox;

import java.security.Permission;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.module.Module;
import org.terasology.gestalt.module.sandbox.PermissionProvider;
import org.terasology.gestalt.module.sandbox.PermissionProviderFactory;

public class WarnOnlyProviderFactory
implements PermissionProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(WarnOnlyProviderFactory.class);
    private PermissionProviderFactory wrappedFactory;

    public WarnOnlyProviderFactory(PermissionProviderFactory wrappedFactory) {
        this.wrappedFactory = wrappedFactory;
    }

    @Override
    public PermissionProvider createPermissionProviderFor(final Module module, final Predicate<Class<?>> classpathModuleClasses) {
        return new PermissionProvider(){
            private PermissionProvider wrapped;
            {
                this.wrapped = WarnOnlyProviderFactory.this.wrappedFactory.createPermissionProviderFor(module, classpathModuleClasses);
            }

            @Override
            public boolean isPermitted(Class<?> type) {
                if (!this.wrapped.isPermitted(type)) {
                    logger.error("Use of non-permitted class '{}' detected by module '{}': this should be fixed for production use", (Object)type.toString(), (Object)module);
                }
                return true;
            }

            @Override
            public boolean isPermitted(Permission permission, Class<?> context) {
                if (!this.wrapped.isPermitted(permission, context)) {
                    logger.error("Non-permitted permission '{}' required by module '{}', class '{}': this should be fixed for production use", new Object[]{permission, module, context});
                }
                return true;
            }
        };
    }
}

